package com.yd.csf.service.dto;

import lombok.Data;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 来佣绑定的保单和转介人信息封装
 */
@Data
public class CommissionBindPolicyBrokerDto {

    /**
     * 保单号
     */
    private String policyNo;

    //======来佣信息start=======
    /**
     * 保单来佣业务id
     */
    private String commissionBizId;

    /**
     * 佣金期数(1=第一年; 2=第二年; 3=第三年; 4=第四年; 5=第五年)
     */
    private Integer commissionPeriod;

    /**
     * 总来佣期数
     */
    private Integer totalPeriod;

    /**
     * 来佣名称(1:销售拥金;2:销售奖金;3:销售津贴;4:续期佣金;5:服务津贴;等等)
     */
    private String commissionName;

    /**
     * 来佣类型(1:销售拥金;2:销售奖金;3:销售津贴;4:续期佣金;5:服务津贴;等等)
     */
    private String commissionType;

    /**
     * 来佣金额
     */
    private BigDecimal amount;

    /**
     * 来佣币种
     */
    private String currency;

    /**
     * 来佣日期
     */
    private Date commissionDate;

    /**
     * 来佣状态 0=未比对 1=比对成功 2=比对失败
     */
    private String commissionStatus;
    //======来佣信息end=======

    //======保单信息start=======
    /**
     * 用户业务id
     */
    private String userBizId;

    /**
     * 产品业务id
     */
    private String planBizId;

    /**
     * 产品代码
     */
    private String productCode;
    //======保单信息end=======

    //======保单转介人信息start=======
    /**
     * 转介人名称
     */
    private String brokerName;

    /**
     * 转介人业务ID（客户端用户表唯一业务ID）
     */
    private String brokerBizId;

    /**
     * 所属团队
     */
    private String team;

    /**
     * 所属团队业务id
     */
    private String teamBizId;
    //======保单转介人信息end=======
}
