package com.yd.csf.service.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yd.csf.service.model.Commission;
import com.yd.csf.service.model.CommissionExpected;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
@Schema(description = "预计来佣响应")
public class CommissionExpectedVO implements Serializable {

    /**
     * 预计来佣id
     */
    @Schema(description = "预计来佣id")
    private Long id;

    /**
     * 预计来佣业务id
     */
    @Schema(description = "预计来佣业务id")
    private String commissionExpectedBizId;

    /**
     * 应收账款编号
     */
    @Schema(description = "应收账款编号")
    private String receivableNo;

    /**
     * 应收款类型 1=关联保单应收单 2=非关联保单应收单
     */
    @Schema(description = "应收款类型 1=关联保单应收单 2=非关联保单应收单")
    private Integer commissionBizType;

    /**
     * 保单号
     */
    @Schema(description = "保单号")
    private String policyNo;

    /**
     * 保险公司业务ID
     */
    @Schema(description = "保险公司业务ID")
    private String insurerBizId;

    /**
     * 产品上架信息表唯一业务ID
     */
    @Schema(description = "产品计划: 产品上架信息表唯一业务ID")
    private String productLaunchBizId;

    /**
     * 保费
     */
    @Schema(description = "保费")
    private Object premium;

    /**
     * 对账公司
     */
    @Schema(description = "对账公司")
    private String reconciliationCompany;

    /**
     * 佣金期数(1=第一年; 2=第二年; 3=第三年; 4=第四年; 5=第五年)
     */
    @Schema(description = "佣金期数(1=第一年; 2=第二年; 3=第三年; 4=第四年; 5=第五年)")
    private Integer commissionPeriod;

    /**
     * 总来佣期数
     */
    @Schema(description = "总来佣期数")
    private Integer totalPeriod;

    /**
     * 来佣名称(1:销售拥金;2:销售奖金;3:销售津贴;4:续期佣金;5:服务津贴;等等)
     */
    @Schema(description = "来佣名称(1:销售拥金;2:销售奖金;3:销售津贴;4:续期佣金;5:服务津贴;等等)")
    private String commissionName;

    /**
     * 来佣类型(1:销售拥金;2:销售奖金;3:销售津贴;4:续期佣金;5:服务津贴;等等)
     */
    @Schema(description = "来佣类型(1:销售拥金;2:销售奖金;3:销售津贴;4:续期佣金;5:服务津贴;等等)")
    private String commissionType;

    /**
     * 预计入账比例 (%)
     */
    @Schema(description = "预计入账比例 (%)")
    private BigDecimal commissionRatio;

    /**
     * 来佣比例 (%)
     */
    @Schema(description = "来佣比例 (%)")
    private BigDecimal ratio;

    /**
     * 来佣币种
     */
    @Schema(description = "来佣币种")
    private String currency;

    /**
     * 预计来佣日期
     */
    @Schema(description = "预计来佣日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date commissionDate;

    /**
     * 入账状态 0=待入账 1=完成入账 2=部分入账 3=已失效
     */
    @Schema(description = "入账状态 0=待入账 1=完成入账 2=部分入账 3=已失效")
    private String status;

    /**
     * 预计入账金额（HKD）
     */
    @Schema(description = "预计入账金额（HKD）")
    private BigDecimal expectedAmount;

    /**
     * 结算汇率（估）
     */
    @Schema(description = "结算汇率（估）")
    private BigDecimal defaultExchangeRate;

    /**
     * 已入账来佣金额（HKD）
     */
    @Schema(description = "已入账来佣金额（HKD）")
    private BigDecimal paidAmount;

    /**
     * 已入账来佣比例 (%)
     */
    @Schema(description = "已入账来佣比例 (%)")
    private BigDecimal paidRatio;

    /**
     * 已入账来佣列表
     */
    @Schema(description = "已入账来佣列表")
    private List<Commission> commissionList;

    /**
     * 通用备注
     */
    @Schema(description = "备注")
    private String remark;

    /**
     * 创建人ID
     */
    @Schema(description = "创建人ID")
    private String creatorId;

    /**
     * 更新人ID
     */
    @Schema(description = "更新人ID")
    private String updaterId;

    /**
     * 创建时间
     */
    @Schema(description = "创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    /**
     * 更新时间
     */
    @Schema(description = "更新时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

    private static final long serialVersionUID = 1L;

    /**
     * 对象转封装类
     *
     * @param commissionExpected
     * @return
     */
    public static CommissionExpectedVO objToVo(CommissionExpected commissionExpected) {
        if (commissionExpected == null) {
            return null;
        }
        CommissionExpectedVO commissionVO = new CommissionExpectedVO();
        BeanUtils.copyProperties(commissionExpected, commissionVO);
        commissionVO.setRatio(commissionExpected.getCommissionRatio());

        return commissionVO;
    }
}
