package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 保费对账-汇款记录表
 * </p>
 *
 * @author zxm
 * @since 2025-12-26
 */
@Getter
@Setter
@TableName("premium_remittance")
public class PremiumRemittance implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 保费对账-汇款记录表唯一业务ID
     */
    @TableField("premium_remittance_biz_id")
    private String premiumRemittanceBizId;

    /**
     * 保费对账记录表唯一业务ID
     */
    @TableField("premium_reconciliation_biz_id")
    private String premiumReconciliationBizId;

    /**
     * 缴费方式
     */
    @TableField("payment_method")
    private String paymentMethod;

    /**
     * 付款金额
     */
    @TableField("payment_amount")
    private BigDecimal paymentAmount;

    /**
     * 付款币种
     */
    @TableField("payment_currency")
    private String paymentCurrency;

    /**
     * 付款人与保单关系（字典）
     */
    @TableField("payment_rel")
    private String paymentRel;

    /**
     * 付款人
     */
    @TableField("payer")
    private String payer;

    /**
     * 付款银行
     */
    @TableField("paying_bank")
    private String payingBank;

    /**
     * 付款账号
     */
    @TableField("payment_account")
    private String paymentAccount;

    /**
     * 支付凭证（多个文件URL用分号分隔）
     */
    @TableField("payment_voucher")
    private String paymentVoucher;

    /**
     * 账户证明（多个文件URL用分号分隔）
     */
    @TableField("account_verification")
    private String accountVerification;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
