package com.yd.csf.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.csf.api.service.ApiExpectedFortuneLogService;
import com.yd.csf.feign.client.expectedfortunelog.ApiExpectedFortuneLogFeignClient;
import com.yd.csf.feign.request.expectedfortunelog.ApiExpectedFortuneLogPageRequest;
import com.yd.csf.feign.response.expectedfortunelog.ApiExpectedFortuneLogPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 生成预计发佣日志记录信息
 *
 * @author zxm
 * @since 2025-11-20
 */
@RestController
@RequestMapping("/expectedFortuneLog")
@Validated
public class ApiExpectedFortuneLogController implements ApiExpectedFortuneLogFeignClient {

    @Autowired
    private ApiExpectedFortuneLogService apiExpectedFortuneLogService;

    /**
     * 分页查询 - 生成预计发佣日志记录
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiExpectedFortuneLogPageResponse>> page(ApiExpectedFortuneLogPageRequest request) {
        return apiExpectedFortuneLogService.page(request);
    }
}
