package com.yd.csf.api.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * 变量算法出参公共封装DTO
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class VariableAlgorithmDto {

    /**
     * 变量表唯一业务ID
     */
    private String variableBizId;

    /**
     * 变量编码
     */
    private String variableCode;

    /**
     * 变量名称中文名
     */
    private String nameCn;

    /**
     * 计算值 - sqlAlgorithmResultDtoList集合里面的计算值和值
     */
    private String calculatedValue;

    /**
     * 当前变量绑定的SQL模板计算结果集合列表（含计算值，以及计算值的提供者等等）
     */
    private List<SqlAlgorithmResultDto> sqlAlgorithmResultDtoList;
}
