package com.yd.csf.feign.request.expectedfortune;

import com.yd.csf.feign.response.expectedfortune.PolicyInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class ExpectedFortuneAddRequest {
    /**
     * 应付款类型 R-关联保单应付款 U-非关联保单应付款
     */
    @Schema(description = "应付款类型 R-关联保单应付款 U-非关联保单应付款")
    private String fortuneBizType;

    /**
     * 保单号
     */
    @Schema(description = "policy no")
    private String policyNo;

    /**
     * 产品上架信息业务ID
     */
    @Schema(description = "产品计划: 产品上架信息业务ID")
    private String productLaunchBizId;

    /**
     * 发佣期数(1=第一年; 2=第二年; 3=第三年; 4=第四年; 5=第五年)
     */
    @Schema(description = "fortune period")
    private Integer fortunePeriod;

    /**
     * 发佣总期数
     */
    @Schema(description = "fortune total period")
    private Integer fortuneTotalPeriod;

    /**
     * 转介人名称
     */
    @Schema(description = "转介人名称")
    private String broker;

    /**
     * 转介人业务ID
     */
    @Schema(description = "broker biz id")
    private String brokerBizId;

    /**
     * 团队名称
     */
    @Schema(description = "团队名称")
    private String team;

    /**
     * 所属团队业务ID
     */
    @Schema(description = "所属团队 biz id")
    private String teamBizId;

    /**
     * 发佣名称
     */
    @Schema(description = "发佣名称")
    private String fortuneName;

    /**
     * 发佣类型
     */
    @Schema(description = "发佣类型")
    private String fortuneType;

    /**
     * 预计应发金额
     */
    @Schema(description = "预计应发金额")
    private BigDecimal amount;

    /**
     * 发佣币种
     */
    @Schema(description = "发佣币种")
    private String currency;

    /**
     * 预计发佣日期
     */
    @Schema(description = "预计发佣日期")
    private LocalDate payoutDate;

}
