package com.yd.csf.service.vo;

import com.google.gson.reflect.TypeToken;
import com.yd.csf.service.dto.TaxCountry;
import com.yd.csf.service.model.Customer;
import com.yd.csf.service.utils.GSONUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * customer视图
 */
@Data
public class CustomerVO implements Serializable {

    /**
     * customer id
     */
    @Schema(description = "customer id")
    private Long id;

    /**
     * 客户唯一业务ID
     */
    @Schema(description = "客户业务ID")
    private String customerBizId;

    /**
     * 姓名-中文
     */
    @Schema(description = "姓名-中文")
    private String nameCn;

    /**
     * 姓名-（拼音/英文，通过中文自动加载全部大写的拼音）
     */
    @Schema(description = "姓名-（拼音/英文，通过中文自动加载全部大写的拼音）")
    private String namePyEn;

    /**
     * 证件类型（字典，下拉选择）
     */
    @Schema(description = "证件类型（字典，下拉选择）")
    private String documentType;

    /**
     * 证件号码
     */
    @Schema(description = "证件号码")
    private String idNumber;

    /**
     * 性别（字典，如果是身份证，自动获取性别和生日）
     */
    @Schema(description = "性别（字典，如果是身份证，自动获取性别和生日）")
    private String gender;

    /**
     * 出生日期（生日，如果是身份证，自动获取性别和生日）
     */
    @Schema(description = "出生日期（生日，如果是身份证，自动获取性别和生日）")
    private Date birthday;

    /**
     * 年龄（通过生日自动获取年龄）
     */
    @Schema(description = "年龄（通过生日自动获取年龄）")
    private String age;

    /**
     * 国籍（下拉选择）
     */
    @Schema(description = "国籍（下拉选择）")
    private String nationality;

    /**
     * 出生地
     */
    @Schema(description = "出生地")
    private String birthplace;

    /**
     * 是否拥有其他国家公民身份（如美国、日本等）: 0-否, 1-是（字典）
     */
    @Schema(description = "是否拥有其他国家公民身份（如美国、日本等）: 0-否, 1-是（字典）")
    private String isOtherCountry;

    /**
     * 税务国家列表
     */
    @Schema(description = "税务国家列表")
    private List<TaxCountry> apiTaxationDtoList;

    /**
     * 吸烟情况（字典）
     */
    @Schema(description = "吸烟情况（字典）")
    private String smokingStatus;

    /**
     * 婚姻情况（字典）
     */
    @Schema(description = "婚姻情况（字典）")
    private String maritalStatus;

    /**
     * 教育程度（字典）
     */
    @Schema(description = "教育程度（字典）")
    private String educationLevel;

    /**
     * 是否退休（字典）
     */
    @Schema(description = "是否退休（字典）")
    private String isRetirement;

    /**
     * 退休年龄（如已退休，再显示）
     */
    @Schema(description = "退休年龄（如已退休，再显示）")
    private String retirementAge;

    /**
     * 身高（CM)
     */
    @Schema(description = "身高（CM)")
    private String height;

    /**
     * 体重（KG)
     */
    @Schema(description = "体重（KG)")
    private String weight;

    /**
     * BMI指数（根据身高和体重自动计算）
     */
    @Schema(description = "BMI指数（根据身高和体重自动计算）")
    private String bmi;

    /**
     * 风险偏好（字典，下拉选择）
     */
    @Schema(description = "风险偏好（字典，下拉选择）")
    private String riskAppetite;

    /**
     * 受供养人数目（通过FNA带入）
     */
    @Schema(description = "受供养人数目（通过FNA带入）")
    private Integer dependentsNum;

    /**
     * 移动电话区号
     */
    @Schema(description = "移动电话区号")
    private String mobileCode;

    /**
     * 移动电话
     */
    @Schema(description = "移动电话")
    private String mobile;

    /**
     * 住宅电话区号
     */
    @Schema(description = "住宅电话区号")
    private String residenceMobileCode;

    /**
     * 住宅电话
     */
    @Schema(description = "住宅电话")
    private String residenceMobile;

    /**
     * 固定电话区号
     */
    @Schema(description = "固定电话区号")
    private String landlineCode;

    /**
     * 固定电话
     */
    @Schema(description = "固定电话")
    private String landline;

    /**
     * 邮箱
     */
    @Schema(description = "邮箱")
    private String email;

    /**
     * 证件地址
     */
    @Schema(description = "证件地址")
    private String certificateAddress;

    /**
     * 通讯地址
     */
    @Schema(description = "通讯地址")
    private String mailingAddress;

    /**
     * 居住地址（住宅地址）
     */
    @Schema(description = "居住地址（住宅地址）")
    private String residentialAddress;

    /**
     * 通讯地址邮政编号
     */
    @Schema(description = "通讯地址邮政编号")
    private String mailingAddressCode;

    /**
     * 就业情况（字典，下拉选择）
     */
    @Schema(description = "就业情况（字典，下拉选择）")
    private String employmentStatus;

    /**
     * 公司/学校名称
     */
    @Schema(description = "公司/学校名称")
    private String csName;

    /**
     * 行业
     */
    @Schema(description = "行业")
    private String industry;

    /**
     * 现时每月收入（HKD）
     */
    @Schema(description = "现时每月收入（HKD）")
    private BigDecimal currentMonthlyIncome;

    /**
     * 总工作年期
     */
    @Schema(description = "总工作年期")
    private BigDecimal totalWorkingYears;

    /**
     * 受雇于现职年期
     */
    @Schema(description = "受雇于现职年期")
    private BigDecimal currentTenure;

    /**
     * 职位
     */
    @Schema(description = "职位")
    private String position;

    /**
     * 公司地址
     */
    @Schema(description = "公司地址")
    private String companyAddress;

    /**
     * 公司电话区号
     */
    @Schema(description = "公司电话区号")
    private String companyMobileCode;

    /**
     * 公司电话
     */
    @Schema(description = "公司电话")
    private String companyMobile;

    /**
     * 公司地址邮政编号
     */
    @Schema(description = "公司地址邮政编号")
    private String companyAddressCode;

    /**
     * 平均每月收入（HKD）
     */
    @Schema(description = "平均每月收入（HKD）")
    private BigDecimal monthIncome;

    /**
     * 平均每月支出（HKD）
     */
    @Schema(description = "平均每月支出（HKD）")
    private BigDecimal monthExpenditure;

    /**
     * 总流动资产（HKD）
     */
    @Schema(description = "总流动资产（HKD）")
    private BigDecimal totalCurrentAssets;

    /**
     * 总负债额（HKD）
     */
    @Schema(description = "总负债额（HKD）")
    private BigDecimal totalDebt;

    /**
     * 旅行（字典）
     */
    @Schema(description = "旅行（字典）")
    private String travel;

    /**
     * 运动（字典，下拉选择）
     */
    @Schema(description = "运动（字典，下拉选择）")
    private String exercise;

    /**
     * 游戏（字典，下拉选择）
     */
    @Schema(description = "游戏（字典，下拉选择）")
    private String game;

    /**
     * 电影/戏剧（字典，下拉选择）
     */
    @Schema(description = "电影/戏剧（字典，下拉选择）")
    private String movieDrama;

    /**
     * 美食（输入）
     */
    @Schema(description = "美食（输入）")
    private String delicacy;

    /**
     * 地址列表（json串）
     */
    @Schema(description = "地址列表")
    private List<AddressVO> addressList;

    /**
     * 通用备注
     */
    @Schema(description = "通用备注")
    private String remark;

    /**
     * 封装类转对象
     *
     * @param customerVO
     * @return
     */
    public static Customer voToObj(CustomerVO customerVO) {
        if (customerVO == null) {
            return null;
        }
        Customer customer = new Customer();
        BeanUtils.copyProperties(customerVO, customer);

        return customer;
    }

    /**
     * 对象转封装类
     *
     * @param customer
     * @return
     */
    public static CustomerVO objToVo(Customer customer) {
        if (customer == null) {
            return null;
        }
        CustomerVO customerVO = new CustomerVO();
        BeanUtils.copyProperties(customer, customerVO);
        if (ObjectUtils.isNotEmpty(customer.getAddressList())) {
            List<AddressVO> addressList = GSONUtil.fromJson((String) customer.getAddressList(), new TypeToken<List<AddressVO>>() {
            }.getType());
            customerVO.setAddressList(addressList);
        }
        if (ObjectUtils.isNotEmpty(customer.getTaxList())) {
            List<TaxCountry> taxList = GSONUtil.fromJson((String) customer.getTaxList(), new TypeToken<List<TaxCountry>>() {
            }.getType());
            customerVO.setApiTaxationDtoList(taxList);
        }

        return customerVO;
    }
}
