package com.yd.csf.api.service.impl;

import com.yd.common.result.Result;
import com.yd.csf.api.dto.AlgorithmResDto;
import com.yd.csf.api.dto.GenerateAgentDetailFycDto;
import com.yd.csf.api.dto.SqlAlgorithmResultDto;
import com.yd.csf.api.service.ApiAgentDetailFycService;
import com.yd.csf.service.model.AgentAccumulatedFyc;
import com.yd.csf.service.model.AgentDetailFyc;
import com.yd.csf.service.service.IAgentAccumulatedFycService;
import com.yd.csf.service.service.IAgentDetailFycService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Slf4j
@Service
public class ApiAgentDetailFycServiceImpl implements ApiAgentDetailFycService {

    @Autowired
    private IAgentDetailFycService iAgentDetailFycService;

    @Autowired
    private IAgentAccumulatedFycService iAgentAccumulatedFycService;

    /**
     * 基本法计算 - 保存积分明细表
     * @param dto
     * @return
     */
    @Override
    public Result saveAgentDetailFyc(GenerateAgentDetailFycDto dto) {
        List<AlgorithmResDto> algorithmResDtoList = dto.getAlgorithmResDtoList();
        List<AgentDetailFyc> agentDetailFycList = new ArrayList<>();
        //根据业务员ID查询业务员累计积分表
        AgentAccumulatedFyc agentAccumulatedFyc = iAgentAccumulatedFycService.queryOne(dto.getAgentId());
        BigDecimal totalFyc = BigDecimal.ZERO;
        if (!Objects.isNull(agentAccumulatedFyc)) {
            totalFyc = agentAccumulatedFyc.getTotalFyc();
        }
        if (!CollectionUtils.isEmpty(algorithmResDtoList)) {
            for (AlgorithmResDto algorithmResDto : algorithmResDtoList){
                AgentDetailFyc agentDetailFyc = new AgentDetailFyc();
                //变化前的业务员总FYC积分 -> 查询
                agentDetailFyc.setBeforeFyc(totalFyc);
                //累加积分值
                totalFyc = totalFyc.add(algorithmResDto.getCalculatedValue());
                //变化值（-代表减少）
                agentDetailFyc.setChangeFyc(algorithmResDto.getCalculatedValue().toString());
                //变化后的业务员总FYC积分
                agentDetailFyc.setAfterFyc(totalFyc);
                //获得积分的业务员（客户端用户唯一业务ID）
                agentDetailFyc.setAgentId(dto.getAgentId());
                //积分来源类型 TODO
//                agentDetailFyc.setSourceType();
                //积分来源基本法项目配置表唯一业务ID
                agentDetailFyc.setRuleItemBizId(algorithmResDto.getRuleItemBizId());
                //提供积分的保单发佣批次ID
                agentDetailFyc.setBatchBizId(dto.getBatchBizId());
                //提供积分的保单号
                agentDetailFyc.setPolicyNo(dto.getPolicyNo());
                //提供积分的业务员（客户端用户唯一业务ID）
                agentDetailFyc.setProvideId(dto.getProvider());
                agentDetailFycList.add(agentDetailFyc);
            }
        }

        if (!CollectionUtils.isEmpty(agentDetailFycList)) {
            //保存积分明细
            iAgentDetailFycService.saveOrUpdateBatch(agentDetailFycList);

            //更新累计积分表的业务员的累计积分字段值
            if (!Objects.isNull(agentAccumulatedFyc)) {
                agentAccumulatedFyc.setTotalFyc(totalFyc);
                iAgentAccumulatedFycService.saveOrUpdate(agentAccumulatedFyc);
            }
        }
        return Result.success();
    }

}
