package com.yd.csf.feign.fallback.approval;

import com.yd.common.result.Result;
import com.yd.csf.feign.client.approval.ApiApprovalFeignClient;
import com.yd.csf.feign.request.approval.ApiApprovalClientUserPageRequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 香港保险服务-审批信息Feign降级处理
 */
@Slf4j
@Component
public class ApiApprovalFeignFallbackFactory implements FallbackFactory<ApiApprovalFeignClient> {
    @Override
    public ApiApprovalFeignClient create(Throwable cause) {
        return new ApiApprovalFeignClient() {
            @Override
            public Result approvalClientUserPage(ApiApprovalClientUserPageRequest request) {
                return null;
            }
        };
    }
}
