package com.yd.csf.feign.dto.appointment;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.time.LocalDateTime;

@Data
public class ApiAppointmentUserSignLogDto {

    /**
     * 预约-签单员信息日志表主键ID
     */
    private Long id;

    /**
     * 预约-签单员信息日志表唯一业务ID
     */
    private String appointmentUserSignLogBizId;

    /**
     * 预约信息日志表唯一业务ID
     */
    private String appointmentLogBizId;

    /**
     * 签单用户扩展唯一业务ID（冗余）
     */
    private String userSignBizId;

    /**
     * 系统用户唯一业务ID（冗余）
     */
    private String userBizId;

    /**
     * 姓名
     */
    private String realName;

    /**
     * 执业编码
     */
    private String practiceCode;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 证件类型
     */
    private String cardType;

    /**
     * 证件号码
     */
    private String cardNo;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 通用备注
     */
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    private String creatorId;

    /**
     * 更新人ID
     */
    private String updaterId;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime updateTime;
}
