package com.yd.csf.service.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 佣金统计VO 包含总金额、总入账金额、待入账金额、已入账比例（已入账金额/总金额）、总保单数
 */
@Data
public class CommissionStatisticsVO {

    /**
     * 入账金额（实）
     */
    @Schema(description = "入账金额（实）")
    private BigDecimal totalPaidAmount;

    /**
     * 入账金额（估）
     */
    @Schema(description = "入账金额（估）")
    private BigDecimal expectePaidAmount;

    /**
     * 待入账金额
     */
    @Schema(description = "待入账金额")
    private BigDecimal pendingPaidAmount;

    /**
     * 差额（估-实）
     */
    @Schema(description = "差额（估-实）")
    private BigDecimal differenceAmount;

    /**
     * 总保单数
     */
    @Schema(description = "总保单数")
    private Integer totalPolicyCount;

    /**
     * 总保费
     */
    @Schema(description = "总保费（HKD）")
    private BigDecimal totalPremium;

    /**
     * 对账公司数
     */
    @Schema(description = "对账公司数")
    private Integer reconciliationCompanyCount;

    /**
     * 总比对记录数
     */
    @Schema(description = "总比对记录数")
    private Integer totalCompareCommissionCount;

    /**
     * 比对成功记录数
     */
    @Schema(description = "比对成功记录数")
    private Integer successCompareCommissionCount;

    /**
     * 比对失败记录数
     */
    @Schema(description = "比对失败记录数")
    private Integer failedCompareCommissionCount;

}
