package com.yd.csf.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.csf.feign.request.ruleItemconfig.ApiRuleItemConfigPageRequest;
import com.yd.csf.feign.response.ruleItemconfig.ApiRuleItemConfigPageResponse;
import com.yd.csf.service.dto.RuleItemConfigDto;
import com.yd.csf.service.model.CommissionRuleConfig;
import com.yd.csf.service.model.RuleItemConfig;
import com.yd.csf.service.dao.RuleItemConfigMapper;
import com.yd.csf.service.service.IRuleItemConfigService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 基本法项目配置表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-10-15
 */
@Service
public class RuleItemConfigServiceImpl extends ServiceImpl<RuleItemConfigMapper, RuleItemConfig> implements IRuleItemConfigService {

    @Override
    public IPage<ApiRuleItemConfigPageResponse> page(Page<ApiRuleItemConfigPageResponse> page,
                                                     ApiRuleItemConfigPageRequest request) {
        return baseMapper.page(page,request);
    }

    /**
     * 查询单个对象
     * @param ruleItemBizId
     * @return
     */
    @Override
    public RuleItemConfig queryOne(String ruleItemBizId) {
        return this.getOne(new LambdaQueryWrapper<RuleItemConfig>().eq(RuleItemConfig::getRuleItemBizId,ruleItemBizId));
    }

    /**
     * 查询列表
     * @param dto
     * @return
     */
    @Override
    public List<RuleItemConfig> queryList(RuleItemConfigDto dto) {
        List<RuleItemConfig> list = baseMapper.selectList(new LambdaQueryWrapper<RuleItemConfig>()
                .eq(StringUtils.isNotBlank(dto.getRuleItemBizId()) && !dto.getIsExcludeMy(),RuleItemConfig::getRuleItemBizId,dto.getRuleItemBizId())
                .eq(StringUtils.isNotBlank(dto.getItemName()),RuleItemConfig::getItemName,dto.getItemName())
                .eq(StringUtils.isNotBlank(dto.getRuleBizId()),RuleItemConfig::getRuleBizId,dto.getRuleBizId())
                .ne(dto.getIsExcludeMy(),RuleItemConfig::getRuleItemBizId,dto.getRuleItemBizId())
                .orderByAsc(RuleItemConfig::getExecutionOrder)
        );
        return list;
    }
}
