package com.yd.csf.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.csf.service.dto.CommissionRuleBindingDto;
import com.yd.csf.service.model.CommissionRuleBinding;
import com.yd.csf.service.dao.CommissionRuleBindingMapper;
import com.yd.csf.service.model.CommissionSqlTemplate;
import com.yd.csf.service.service.ICommissionRuleBindingService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * <p>
 * 基本法绑定表 - 存储基本法与业务员或团队的绑定关系，支持灵活的权限分配 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-10-15
 */
@Service
public class CommissionRuleBindingServiceImpl extends ServiceImpl<CommissionRuleBindingMapper, CommissionRuleBinding> implements ICommissionRuleBindingService {

    /**
     * 查询列表
     * @param dto
     * @return
     */
    @Override
    public List<CommissionRuleBinding> queryList(CommissionRuleBindingDto dto) {
        List<CommissionRuleBinding> list = baseMapper.selectList(new LambdaQueryWrapper<CommissionRuleBinding>()
                .eq(StringUtils.isNotBlank(dto.getTargetId()),CommissionRuleBinding::getTargetId,dto.getTargetId())
        );
        return list;
    }


}
