package com.yd.csf.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 算法-基本法计算-返回的对象
 */
@Data
public class AlgorithmResDto {


    /**
     * 基本法配置表唯一业务ID（基本法类型）
     */
    private String ruleBizId;

    /**
     * 基本法项目配置表唯一业务ID
     */
    private String ruleItemBizId;

    /**
     * 基本法项目名称
     */
    private String itemName;

    /**
     * 计算值 - sqlAlgorithmResultDtoList集合里面的计算值和值
     */
    private BigDecimal calculatedValue;

    /**
     * 当前变量绑定的SQL模板计算结果集合列表（含计算值，以及计算值的提供者等等）（sql语句返回多个值作为算子计算）
     * SQL计算结果按照积分贡献者或者其他维度分组的集合计算结果列表
     */
    private List<SqlAlgorithmResultDto> sqlAlgorithmResultDtoList;
}
