package com.yd.csf.api.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import java.util.List;

/**
 * 算法DTO - 公共入参封装
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class AlgorithmDto {

    /**
     * 保单发佣批次ID
     */
    private String batchBizId;

    /**
     * 转介人业务ID（客户端用户表唯一业务ID）
     */
    private String brokerBizId;

    /**
     * 基本法配置表唯一业务ID（业务员绑定的基本法类型（类型中含多个基本法项目（基本法项目绑定公式）））
     */
    private String ruleBizId;

    /**
     * 基本法项目配置表唯一业务ID
     */
    private String ruleItemBizId;

    /**
     * 公式配置表唯一业务ID
     */
    private String formulaBizId;

    /**
     * 变量表业务ID集合列表
     */
    private List<String> variableBizIdList;

    /**
     * SQL模板表唯一业务ID
     */
    private String sqlTemplateBizId;

    /**
     * SQL模板条件入参参数及参数值对象（通用，用于各种SQL模板计算值入参条件参数值，这边集成大部分SQL模所需的条件参数，SQL模板会去匹配入参sqlTemplateParamDto有符合的就作为条件参数）
     */
    private SqlTemplateParamDto sqlTemplateParamDto;

    /**
     * 需要执行的基本法项目的执行顺序下标值列表（为空就是执行全部项目）
     */
    private List<Integer> executionOrderList;

    /**
     * 需要执行的基本法项目的执行顺序下标值列表是否取反执行（true-取反就是非executionOrderList的列表执行，false-不取反就是executionOrderList的列表执行）
     */
    private Boolean isNegateExecutionOrderList;
}
