package com.yd.csf.feign.client.approval;

import com.yd.common.result.Result;
import com.yd.csf.feign.fallback.approval.ApiApprovalFeignFallbackFactory;
import com.yd.csf.feign.request.approval.ApiApprovalClientUserPageRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 香港保险服务-审批信息Feign客户端
 */
@FeignClient(name = "yd-csf-api",fallbackFactory = ApiApprovalFeignFallbackFactory.class)
public interface ApiApprovalFeignClient {

    /**
     * 审批列表-客户端用户信息
     * @param request
     * @return
     */
    @PostMapping("/client/user/page")
    Result approvalClientUserPage(@RequestBody ApiApprovalClientUserPageRequest request);
}
