package com.yd.csf.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yd.csf.service.dto.PolicyDto;
import com.yd.csf.service.dto.PolicyQueryRequest;
import com.yd.csf.service.model.AppointmentFile;
import com.yd.csf.service.model.Policy;
import com.yd.csf.service.service.PolicyService;
import com.yd.csf.service.dao.PolicyMapper;
import com.yd.csf.service.vo.PolicyVO;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
* @author Zhang Jianan
* @description 针对表【policy(保单表)】的数据库操作Service实现
* @createDate 2025-09-18 15:07:25
*/
@Service
public class PolicyServiceImpl extends ServiceImpl<PolicyMapper, Policy>
    implements PolicyService{

    @Override
    public QueryWrapper<Policy> getQueryWrapper(PolicyQueryRequest policyQueryRequest) {
        QueryWrapper<Policy> queryWrapper = new QueryWrapper<>();
        if (policyQueryRequest == null) {
            return queryWrapper;
        }
        String status = policyQueryRequest.getStatus();
        String policyNo = policyQueryRequest.getPolicyNo();
        String customerName = policyQueryRequest.getCustomerName();
        String customerBizId = policyQueryRequest.getCustomerBizId();
        String insurer = policyQueryRequest.getInsurer();
        String productName = policyQueryRequest.getProductName();
        String issueDateStart = policyQueryRequest.getIssueDateStart();
        String issueDateEnd = policyQueryRequest.getIssueDateEnd();

        queryWrapper.eq(StringUtils.isNotBlank(status), "status", status);
        queryWrapper.eq(StringUtils.isNotBlank(policyNo), "policy_no", policyNo);
        queryWrapper.eq(StringUtils.isNotBlank(customerName), "customer_name", customerName);
        queryWrapper.eq(StringUtils.isNotBlank(customerBizId), "customer_biz_id", customerBizId);
        queryWrapper.eq(StringUtils.isNotBlank(insurer), "insurer", insurer);
        queryWrapper.eq(StringUtils.isNotBlank(productName), "product_name", productName);
        queryWrapper.ge(StringUtils.isNotBlank(issueDateStart), "issue_date", issueDateStart);
        queryWrapper.le(StringUtils.isNotBlank(issueDateEnd), "issue_date", issueDateEnd);

        // 默认排序
        queryWrapper.orderByDesc("id");

        return queryWrapper;
    }

    @Override
    public Page<PolicyVO> getPolicyVOPage(Page<Policy> policyPage) {
        List<Policy> policyList = policyPage.getRecords();
        Page<PolicyVO> policyVOPage = new Page<>(policyPage.getCurrent(), policyPage.getSize(), policyPage.getTotal());
        if (CollUtil.isEmpty(policyList)) {
            return policyVOPage;
        }

        // 填充信息
        List<PolicyVO> policyVOList = policyList.stream().map(policy -> {
            PolicyVO policyVO = PolicyVO.objToVo(policy);
            return policyVO;
        }).collect(Collectors.toList());
        policyVOPage.setRecords(policyVOList);
        return policyVOPage;
    }

    /**
     * 查询列表
     * @param dto
     * @return
     */
    @Override
    public List<Policy> queryList(PolicyDto dto) {
        List<Policy> list = baseMapper.selectList(new LambdaQueryWrapper<Policy>()
                .in(!CollectionUtils.isEmpty(dto.getPolicyNoList()),Policy::getPolicyNo,dto.getPolicyNoList())
        );
        return list;
    }
}





