package com.yd.csf.api.service.impl;

import com.yd.common.exception.BusinessException;
import com.yd.common.result.Result;
import com.yd.csf.api.service.ApiBasicLawCalculateService;
import com.yd.csf.feign.request.basiclawcalculate.ApiGenerateBillingRequest;
import com.yd.csf.feign.response.basiclawcalculate.ApiGenerateBillingResponse;
import com.yd.csf.service.dto.CommissionDto;
import com.yd.csf.service.dto.PolicyDto;
import com.yd.csf.service.dto.QueryPolicyBrokerDto;
import com.yd.csf.service.model.Commission;
import com.yd.csf.service.model.Policy;
import com.yd.csf.service.model.PolicyBroker;
import com.yd.csf.service.service.CommissionService;
import com.yd.csf.service.service.PolicyBrokerService;
import com.yd.csf.service.service.PolicyService;
import com.yd.insurance.base.feign.client.ApiRelProductAnnouncementFeignClient;
import com.yd.insurance.base.feign.dto.ApiProductRatioDto;
import com.yd.insurance.base.feign.request.ApiQueryRatioRequest;
import com.yd.insurance.base.feign.response.ApiQueryRatioResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

@Slf4j
@Service
public class ApiBasicLawCalculateServiceImpl implements ApiBasicLawCalculateService {

    @Autowired
    private PolicyService policyService;

    @Autowired
    private CommissionService commissionService;

    @Autowired
    private ApiRelProductAnnouncementFeignClient apiRelProductAnnouncementFeignClient;

    @Autowired
    private PolicyBrokerService policyBrokerService;

    /**
     * 生成出账
     * @param request
     * @return
     */
    @Override
    public Result<ApiGenerateBillingResponse> generateBilling(ApiGenerateBillingRequest request) {
        //根据保单来佣业务id列表查询保单业务ID列表
        List<Commission> commissionList = commissionService.queryList(CommissionDto.builder().commissionBizIdList(request.getCommissionBizIdList()).build());
        if (CollectionUtils.isEmpty(commissionList)) {
            throw new BusinessException("来佣数据不存在");
        }
        // 根据保单号分组，取每组的第一条, 获取最后的去重的来佣列表
        List<Commission> distinctCommissionList = commissionList.stream()
                .collect(Collectors.collectingAndThen(
                        Collectors.toMap(
                                Commission::getPolicyNo,  // 保单号作为key
                                Function.identity(),      // Commission对象本身作为value
                                (existing, replacement) -> existing  // 遇到重复key时保留已存在的
                        ),
                        map -> new ArrayList<>(map.values())));
        //获取保单号列表
        List<String> policyNoList = distinctCommissionList.stream().map(Commission::getPolicyNo).collect(Collectors.toList());
        //查询保单列表信息
        List<Policy> policyList =  policyService.queryList(PolicyDto.builder().policyNoList(policyNoList).build());
        //根据产品代码列表查询公告比例
        ApiQueryRatioRequest ratioRequest = new ApiQueryRatioRequest();
        List<ApiProductRatioDto> apiProductRatioDtoList = distinctCommissionList.stream().map(dto -> {
            ApiProductRatioDto ratioDto = new ApiProductRatioDto();
            if (!CollectionUtils.isEmpty(policyList)) {
                //保单绑定的产品代码
                List<Policy> policies = policyList.stream().filter(d -> d.getPolicyNo().equals(dto.getPolicyNo())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(policies)) {
                    Policy policy = policies.get(0);
                    ratioDto.setProductCode(policy.getProductCode());
                }
            }
            //佣金期数(1=第一年; 2=第二年; 3=第三年; 4=第四年; 5=第五年等)
            ratioDto.setCommissionPeriod(dto.getCommissionPeriod());
            return ratioDto;
        }).collect(Collectors.toList());
        ratioRequest.setApiProductRatioDtoList(apiProductRatioDtoList);
        Result<ApiQueryRatioResponse> result = apiRelProductAnnouncementFeignClient.queryRatio(ratioRequest);

        if (!CollectionUtils.isEmpty(policyList)) {
            //查询保单转介人（销售人员）关系数据
            List<PolicyBroker> policyBrokerList = policyBrokerService.queryList(QueryPolicyBrokerDto.builder().policyNoList(policyNoList).build());
            for (Policy policy : policyList) {
                List<PolicyBroker> thisPolicyBrokerList = new ArrayList<>();
                //当前保单的绑定的转介人（销售人员）列表
                if (!CollectionUtils.isEmpty(policyBrokerList)) {
                    thisPolicyBrokerList = policyBrokerList.stream().filter(d -> d.getPolicyNo().equals(policy.getPolicyNo())).collect(Collectors.toList());
                }
                if (!CollectionUtils.isEmpty(thisPolicyBrokerList)) {
                    //遍历当前保单绑定的转介人列表，根据人绑定的基本法项目（计算销售佣金，推荐佣金，辅导员佣金，终身推荐奖等。）绑定什么项目算什么金额，按照佣金项目执行顺序来计算。
                    for (PolicyBroker policyBroker : thisPolicyBrokerList) {
                        
                    }
                }
            }
        }
        return null;
    }

}
