package com.yd.csf.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.csf.feign.request.appointment.ApiAppointmentPageRequest;
import com.yd.csf.feign.response.appointment.ApiAppointmentPageResponse;
import com.yd.csf.service.dto.ItineraryDto;
import com.yd.csf.service.model.Appointment;
import com.yd.csf.service.dao.AppointmentMapper;
import com.yd.csf.service.service.IAppointmentService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 预约信息主表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-09-01
 */
@Service
public class AppointmentServiceImpl extends ServiceImpl<AppointmentMapper, Appointment> implements IAppointmentService {

    /**
     * 预约分页查询
     * @param request
     * @return
     */
    @Override
    public IPage<ApiAppointmentPageResponse> page(Page<ApiAppointmentPageResponse> page,
                                                  ApiAppointmentPageRequest request) {
        return baseMapper.page(page,request);
    }

    /**
     * 根据业务id查询单个对象
     * @param appointmentBizId
     * @return
     */
    @Override
    public Appointment queryOne(String appointmentBizId) {
        return this.getOne(new LambdaQueryWrapper<Appointment>().eq(Appointment::getAppointmentBizId,appointmentBizId));
    }

    /**
     * 获取行程单的数据
     * @param appointmentBizId
     * @return
     */
    public ItineraryDto getItineraryDto(String appointmentBizId){
        return baseMapper.getItineraryDto(appointmentBizId);
    }

}
