package com.yd.csf.service.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.csf.service.dto.FnaQueryRequest;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yd.csf.service.model.Fna;
import com.yd.csf.service.vo.FnaVO;

/**
* @author Zhang Jianan
* @description 针对表【fna(fna表)】的数据库操作Service
* @createDate 2025-08-29 14:29:15
*/
public interface FnaService extends IService<Fna> {

    boolean addFna(Fna fna);

    /**
     * 获取查询条件
     *
     * @param fnaQueryRequest
     * @return
     */
    QueryWrapper<Fna> getQueryWrapper(FnaQueryRequest fnaQueryRequest);

    /**
     * 获取fna封装
     *
     * @param fna
     * @return
     */
    FnaVO getFnaVO(Fna fna);

    /**
     * 分页获取fna封装
     *
     * @param fnaPage
     * @return
     */
    Page<FnaVO> getFnaVOPage(Page<Fna> fnaPage);

    Fna getByBizId(String fnaBizId);

    boolean updateByBizId(Fna fna);

    Fna queryOne(String fnaBizId);
}
