package com.yd.csf.service.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yd.csf.service.dto.FnaFormAddRequest;
import com.yd.csf.service.dto.FnaFormQueryRequest;
import com.yd.csf.service.dto.FnaFormUpdateRequest;
import com.yd.csf.service.dto.PersonalData;
import com.yd.csf.service.model.FnaForm;
import com.yd.csf.service.vo.FnaFormVO;


/**
 * Fna表单服务
 *
 */
public interface FnaFormService extends IService<FnaForm> {

    /**
     * 校验数据
     *
     * @param fnaForm
     * @param saveType 保存类型
     */
    void validFnaForm(FnaForm fnaForm, String saveType);

    /**
     * 获取查询条件
     *
     * @param fnaFormQueryRequest
     * @return
     */
    QueryWrapper<FnaForm> getQueryWrapper(FnaFormQueryRequest fnaFormQueryRequest);
    
    /**
     * 获取Fna表单封装
     *
     * @param fnaForm
     * @return
     */
    FnaFormVO getFnaFormVO(FnaForm fnaForm);

    /**
     * 分页获取Fna表单封装
     *
     * @param fnaFormPage
     * @return
     */
    Page<FnaFormVO> getFnaFormVOPage(Page<FnaForm> fnaFormPage);

    void validFnaFormAdd(PersonalData personalData, String saveType);

    FnaForm getFnaForm(FnaFormAddRequest fnaFormAddRequest);

    FnaForm getFnaForm(FnaFormUpdateRequest fnaFormUpdateRequest);

    FnaForm getByFnaFormBizId(String fnaFormBizId);

    PersonalData getPersonalDataObj(Object personalData);
}
