package com.yd.csf.feign.fallback.policyholder;

import com.yd.common.result.Result;
import com.yd.csf.feign.client.policyholder.ApiPolicyholderFeignClient;
import com.yd.csf.feign.dto.appointment.ApiPolicyholderInfoDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;

/**
 * 香港保险服务-投保人信息Feign降级处理
 */
@Slf4j
@Component
public class ApiPolicyholderFeignFallbackFactory implements FallbackFactory<ApiPolicyholderFeignClient> {
    @Override
    public ApiPolicyholderFeignClient create(Throwable cause) {
        return new ApiPolicyholderFeignClient() {
            @Override
            public Result edit(ApiPolicyholderInfoDto apiPolicyholderInfoDto) {
                return null;
            }

            @Override
            public Result<ApiPolicyholderInfoDto> detail(String appointmentBizId, String policyholderBizId) {
                return null;
            }

        };
    }
}
