package com.yd.csf.api.controller;

import com.yd.common.result.Result;
import com.yd.csf.api.service.ApiCsfCommonService;
import com.yd.csf.feign.client.common.ApiCsfCommonFeignClient;
import com.yd.csf.feign.request.common.ApiCsfCalculateRequest;
import com.yd.csf.feign.response.common.ApiCsfCalculateResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 公共接口信息
 *
 * @author zxm
 * @since 2025-12-18
 */
@RestController
@RequestMapping("/common")
@Validated
public class ApiCsfCommonController implements ApiCsfCommonFeignClient {

    @Autowired
    private ApiCsfCommonService apiCsfCommonService;

    /**
     * 计算-字段值
     * @param request
     * @return
     */
    @Override
    public Result<List<ApiCsfCalculateResponse>> calculate(ApiCsfCalculateRequest request) {
        return apiCsfCommonService.calculate(request);
    }

}
