package com.yd.csf.feign.client.policyholder;

import com.yd.common.result.Result;
import com.yd.csf.feign.dto.appointment.ApiPolicyholderInfoDto;
import com.yd.csf.feign.dto.appointment.ApiProductPlanInfoDto;
import com.yd.csf.feign.fallback.policyholder.ApiPolicyholderFeignFallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotBlank;

/**
 * 香港保险服务-投保人信息Feign客户端
 */
@FeignClient(name = "yd-csf-api", fallbackFactory = ApiPolicyholderFeignFallbackFactory.class)
public interface ApiPolicyholderFeignClient {

    /**
     * 编辑投保人信息
     * @param apiPolicyholderInfoDto
     * @return
     */
    @PutMapping("/edit")
    Result edit(@Validated @RequestBody ApiPolicyholderInfoDto apiPolicyholderInfoDto);

    /**
     * 投保人信息详情
     * @param appointmentBizId 预约信息主表唯一业务ID
     * @param policyholderBizId 投保人信息表唯一业务ID
     * @return
     */
    @GetMapping("/detail")
    Result<ApiPolicyholderInfoDto> detail(
            @RequestParam(value = "appointmentBizId") String appointmentBizId,
            @RequestParam(value = "policyholderBizId") String policyholderBizId);
}
