package com.yd.csf.service.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.csf.feign.request.expectedfortune.ApiExpectedFortunePageRequest;
import com.yd.csf.feign.response.expectedfortune.ApiExpectedFortunePageResponse;
import com.yd.csf.service.model.ExpectedFortune;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yd.csf.service.vo.ExpectedFortuneStatisticsVO;
import com.yd.csf.service.vo.PayableReportVO;

import java.util.List;

/**
 * <p>
 * 预计发佣表 服务类
 * </p>
 *
 * @author zxm
 * @since 2025-11-17
 */
public interface IExpectedFortuneService extends IService<ExpectedFortune> {

    IPage<ApiExpectedFortunePageResponse> page(Page<ApiExpectedFortunePageResponse> page,
                                               ApiExpectedFortunePageRequest request);

    List<ExpectedFortune> listByPolicyBizId(String policyBizId);

    List<ExpectedFortune> queryList(String policyNo);

    Boolean batchDelByPolicyNo(String policyNo);

    ExpectedFortuneStatisticsVO getStatistics(List<Long> expectedFortuneIds);

    IPage<ApiExpectedFortunePageResponse> getVOPage(IPage<ExpectedFortune> iPage);

    List<ApiExpectedFortunePageResponse> toVOList(List<ExpectedFortune> fortuneList);

    /**
     * 应付款报表 - 按保单号和期数维度统计（分页）
     * @param page 分页参数
     * @param expectedFortuneIds 预计发佣ID列表
     * @return 应付款报表VO分页列表
     */
    IPage<PayableReportVO> payableReportPage(Page<PayableReportVO> page, List<Long> expectedFortuneIds);
}
