package com.yd.csf.feign.client.variable;

import com.yd.common.result.Result;
import com.yd.csf.feign.fallback.variable.ApiVariableFeignFallbackFactory;
import com.yd.csf.feign.request.variable.ApiVariableAddRequest;
import com.yd.csf.feign.request.variable.ApiVariableEditRequest;
import com.yd.csf.feign.request.variable.ApiVariablePageRequest;
import com.yd.csf.feign.response.variable.ApiVariableDetailResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import javax.validation.constraints.NotBlank;

/**
 * 香港保险服务-变量信息Feign客户端
 */
@FeignClient(name = "yd-csf-api", fallbackFactory = ApiVariableFeignFallbackFactory.class)
public interface ApiVariableFeignClient {

    /**
     * 分页查询-变量信息
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiVariablePageRequest request);

    /**
     * 详情-变量信息
     * @param variableBizId
     * @return
     */
    @GetMapping("/detail")
    Result<ApiVariableDetailResponse> detail(@NotBlank(message = "变量信息表唯一业务ID不能为空不能为空") @RequestParam(value = "variableBizId") String variableBizId);

    /**
     * 添加-变量信息
     * @param request
     * @return
     */
    @PostMapping("/add")
    Result add(@Validated @RequestBody ApiVariableAddRequest request);

    /**
     * 编辑-变量信息
     * @param request
     * @return
     */
    @PutMapping("/edit")
    Result edit(@Validated @RequestBody ApiVariableEditRequest request);

    /**
     * 删除-变量信息 TODO
     * @param variableBizId
     * @return
     */
    @DeleteMapping("/del")
    Result del(@NotBlank(message = "变量信息表唯一业务ID不能为空不能为空") @RequestParam(value = "variableBizId") String variableBizId);

}
