package com.yd.csf.service.dto;

import com.yd.csf.service.vo.AddressVO;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 创建customer请求
 *
 */
@Data
public class CustomerAddRequest implements Serializable {

    /**
     * 自定义代码
     */
//    private String customCode;

    /**
     * 姓氏
     */
    @Schema(description = "姓氏")
    private String lastName;

    /**
     * 名字
     */
    @Schema(description = "名字")
    private String firstName;

    /**
     * 姓名
     */
    @Schema(description = "姓名")
    private String name;

    /**
     * 姓氏拼音
     */
    @Schema(description = "姓氏拼音")
    private String lastNamePinyin;

    /**
     * 名字拼音
     */
    @Schema(description = "名字拼音")
    private String firstNamePinyin;

    /**
     * 拼音全称
     */
    @Schema(description = "姓名拼音")
    private String pinyin;

    /**
     * 称谓
     */
    @Schema(description = "称谓")
    private String title;

    /**
     * 性别
     */
    @Schema(description = "性别")
    private Object gender;

    /**
     * 生日
     */
    @Schema(description = "生日")
    private Date birthday;

    /**
     * 出生日期
     */
    @Schema(description = "客户出生日期")
    private Date birthdate;

    /**
     * 异常信息
     */
    @Schema(description = "客户异常信息")
    private String abnormal;

    /**
     * 年龄
     */
    @Schema(description = "年龄")
    private String age;

    /**
     * 地区代码
     */
    @Schema(description = "地区代码")
    private String areaCode;

    /**
     * 电话号码
     */
    @Schema(description = "电话号码")
    private String phone;

    /**
     * 电子邮箱
     */
    @Schema(description = "电子邮箱")
    private String email;

    /**
     * 是否吸烟
     */
    @Schema(description = "是否吸烟")
    private String smoke;

    /**
     * 吸烟数量
     */
    @Schema(description = "吸烟数量")
    private String smokeQuantity;

    /**
     * 公司类型
     */
    @Schema(description = "公司类型")
    private String companyType;

    /**
     * 来源
     */
    @Schema(description = "客户来源")
    private String source;

    /**
     * 证件类型
     */
    @Schema(description = "证件类型")
    private String idType;

    /**
     * 证件号码
     */
    @Schema(description = "证件号码")
    private String idCard;

    /**
     * 护照号
     */
    @Schema(description = "护照号")
    private String passport;

    /**
     * 往来港澳通行证号码
     */
    @Schema(description = "往来港澳通行证号码")
    private String eepCode;

    /**
     * 婚姻状况
     */
    @Schema(description = "婚姻状况")
    private Object marriage;

    /**
     * 出生地
     */
    @Schema(description = "出生地")
    private String birthplace;

    /**
     * 教育程度
     */
    @Schema(description = "教育程度")
    private Object education;

    /**
     * 国家
     */
    @Schema(description = "国家")
    private String country;

    // region 客户扩展信息

    /**
     * 客户类型
     */
    @Schema(description = "客户类型 个人-INDIVIDUAL, 企业-COMPANY")
    private String customerType;

    /**
     * 居住地区代码
     */
    @Schema(description = "居住地区代码")
    private String residenceAreaCode;

    /**
     * 住宅电话
     */
    @Schema(description = "住宅电话")
    private String residenceTelephone;

    /**
     * 是否长期出国
     */
    @Schema(description = "是否长期出国")
    private String longtimeAbroad;

    /**
     * 居住地址
     */
    private AddressVO residenceAddress;

    /**
     * 住宅地址
     */
    private AddressVO residentialAddress;

    /**
     * 邮寄地址
     */
    private AddressVO mailingAddress;

    /**
     * 公司地址
     */
    private AddressVO companyAddress;

    /**
     * 公司名称
     */
    @Schema(description = "公司名称")
    private String companyName;

    /**
     * 公司地区代码
     */
    @Schema(description = "公司地区代码")
    private String companyAreaCode;

    /**
     * 公司电话
     */
    @Schema(description = "公司电话")
    private String companyTelephone;

    /**
     * 职位
     */
    @Schema(description = "职位")
    private String position;

    /**
     * 工作年限
     */
    @Schema(description = "工作年限")
    private String workYear;

    /**
     * 薪资
     */
    @Schema(description = "薪资")
    private BigDecimal salary;

    // endregion

    private static final long serialVersionUID = 1L;
}