package com.yd.csf.feign.dto.appointment;

import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 产品计划-附加险列表
 */
@Data
public class ApiProductPlanAdditionalInfoDto {

    /**
     * 附加险信息表唯一业务ID
     */
    private String additionalBizId;

    /**
     * 产品计划信息表唯一业务ID
     */
    private String planBizId;

    /**
     * 产品上架信息表唯一业务ID
     */
    private String productLaunchBizId;

    /**
     * 产品上架信息表名称（标题）
     */
    private String productLaunchName;

    /**
     * 付款频率（字典）
     */
    private String paymentFrequency;

    /**
     * 供款期数
     */
    private String issueNumber;

    /**
     * 保障年期
     */
    private String guaranteePeriod;

    /**
     * 保单币种
     */
    private String policyCurrency;

    /**
     * 保单额度（重疾）
     */
    private BigDecimal sumInsured;

    /**
     * 每期保费
     */
    private BigDecimal eachIssuePremium;

    /**
     * 保障级别
     */
    private String protectionLevel;

    /**
     * 保障地区（字典）
     */
    private String guaranteeRegion;

    /**
     * 自付额（字典）
     */
    private String deductibles;

    /**
     * 附加保障（json串）
     */
    private String additionalSafeguards;

    /**
     * 保单征费
     */
    private BigDecimal policyLevy;

}
