package com.yd.csf.feign.client.common;

import com.yd.common.result.Result;
import com.yd.csf.feign.fallback.common.ApiCsfCommonFeignFallbackFactory;
import com.yd.csf.feign.request.common.ApiCsfCalculateRequest;
import com.yd.csf.feign.response.common.ApiCsfCalculateResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 香港保险服务-公共接口信息Feign客户端
 */
@FeignClient(name = "yd-csf-api", fallbackFactory = ApiCsfCommonFeignFallbackFactory.class)
public interface ApiCsfCommonFeignClient {

    /**
     * 计算-字段值
     * @param request
     * @return
     */
    @PostMapping("/calculate/fieldValue")
    Result<List<ApiCsfCalculateResponse>> calculate(@Validated @RequestBody ApiCsfCalculateRequest request);
}
