package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

/**
 * 来佣比对记录表
 * @TableName commission_compare_record
 */
@TableName(value ="commission_compare_record")
@Data
public class CommissionCompareRecord implements Serializable {
    /**
     * 主键
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 预计来佣业务id
     */
    @Schema(description = "预计来佣业务id")
    private String commissionExpectedBizId;

    /**
     * 保单来佣业务id
     */
    @Schema(description = "保单来佣业务id")
    private String commissionBizId;

    /**
     * 佣金期数(1=第一年; 2=第二年; 3=第三年; 4=第四年; 5=第五年)
     */
    @Schema(description = "佣金期数(1=第一年; 2=第二年; 3=第三年; 4=第四年; 5=第五年)")
    private Integer commissionPeriod;

    /**
     * 总期数
     */
    @Schema(description = "总期数")
    private Integer totalPeriod;

    /**
     * 比对状态 1=比对成功 2=比对失败
     */
    @Schema(description = "比对状态 1=比对成功 2=比对失败")
    private String status;

    /**
     * 来佣币种
     */
    @Schema(description = "来佣币种")
    private String currency;

    /**
     * 比对时间
     */
    @Schema(description = "比对时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    /**
     * 结算汇率
     */
    @Schema(description = "结算汇率")
    private String exchangeRate;

    /**
     * 入账金额
     */
    @Schema(description = "入账金额")
    private BigDecimal amount;

     /**
     * 当前来佣比例
     */
    @Schema(description = "当前来佣比例")
    private BigDecimal currentCommissionRatio;

    /**
     * 操作人
     */
    @Schema(description = "操作人")
    private String operatorName;

    /**
     * 通用备注
     */
    @JsonIgnore
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @JsonIgnore
    private Integer isDeleted;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}