package com.yd.csf.feign.response.appointment;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yd.csf.feign.dto.appointment.ApiAppointmentReferrerLogDto;
import com.yd.csf.feign.dto.appointment.ApiAppointmentUserSignLogDto;
import lombok.Data;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class ApiAppointmentLogDetailResponse {

    private Long id;

    /**
     * 预约信息日志表唯一业务ID
     */
    private String appointmentLogBizId;

    /**
     * 预约信息主表唯一业务ID
     */
    private String appointmentBizId;

    /**
     * 预约编号
     */
    private String appointmentNo;

    /**
     * 关联客户信息表唯一业务ID（冗余字段）
     */
    private String customerBizId;

    /**
     * 关联客户编号（和客户信息表唯一业务ID是一对，唯一，冗余字段）
     */
    private String customerNo;

    /**
     * 关联FNA信息表唯一业务ID（冗余字段）
     */
    private String fnaBizId;

    /**
     * 关联FNA编号（和FNA信息表唯一业务ID是一对，唯一，冗余字段）
     */
    private String fnaNo;

    /**
     * 关联计划书信息表唯一业务ID（冗余字段）
     */
    private String proposalBizId;

    /**
     * 关联计划书编号（和计划书信息表唯一业务ID是一对，唯一，冗余字段）
     */
    private String proposalNo;

    /**
     * 是否有其他预约同时进行: 0-否, 1-是（字典）
     */
    private Integer isTogether;

    /**
     * 进行同时预约的分组编号
     */
    private String togetherGroupNo;

    /**
     * 进行同时预约的预约编号
     */
    private String togetherAppointmentNo;

    /**
     * 预约状态: 0-暂存 1-待预约, 2-待签署 3-已签署 4-已取消（字典）
     */
    private Integer status;

    /**
     * 申请类型（字典）
     */
    private String applyType;

    /**
     * 业务编号
     */
    private String businessNo;

    /**
     * 意向预约时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime intentionAppointmentTime;

    /**
     * 确定预约时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime confirmAppointmentTime;

    /**
     * 顾问是否陪同: 0-否, 1-是（字典）
     */
    private Integer isAccompany;

    /**
     * 陪同顾问姓名（FNA Form有填写，可带入）
     */
    private String accompanyName;

    /**
     * 陪同顾问手机区号
     */
    private String accompanyMobileCode;

    /**
     * 陪同顾问手机
     */
    private String accompanyMobile;

    /**
     * 陪同顾问邮箱
     */
    private String accompanyEmail;

    /**
     * 业务代表1账号
     */
    private String businessRepresentAccount1;

    /**
     * 业务代表1姓名
     */
    private String businessRepresentName1;

    /**
     * 业务代表1电话号码区号
     */
    private String businessRepresentMobile1Code;

    /**
     * 业务代表1电话号码
     */
    private String businessRepresentMobile1;

    /**
     * 业务代表1邮箱
     */
    private String businessRepresentEmail1;

    /**
     * 到港时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime arrivalTime;

    /**
     * 离港时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime departureTime;

    /**
     * 会面地点（字典）
     */
    private String meetingPoint;

    /**
     * 签单地址
     */
    private String signingAddress;

    /**
     * 客户在港期间联络电话区号
     */
    private String hkMobileCode;

    /**
     * 客户在港期间联络电话
     */
    private String hkMobile;

    /**
     * 是否开户: 0-否, 1-是（字典）
     */
    private Integer isOpenAccount;

    /**
     * 开户行名称
     */
    private String bankName;

    /**
     * 开户行支行（分行）
     */
    private String bankBranchName;

    /**
     * 开户时间段（开始）
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime openAccountStartTime;

    /**
     * 开户时间段（结束）
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime openAccountEndTime;

    /**
     * 开户地点
     */
    private String openAccountLocation;

    /**
     * 开户须知
     */
    private String openAccountNotice;

    /**
     * 是否体检: 0-否, 1-是（字典）
     */
    private Integer isTj;

    /**
     * 是否购买过香港保险: 0-否, 1-是（字典）
     */
    private Integer isBuy;

    /**
     * 转保声明选项(字典)
     */
    private String policyTransfer;

    /**
     * 是否有用车服务：0-否, 1-是（字典）
     */
    private Integer isUseCar;

    /**
     * 通用备注
     */
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    private String creatorId;

    /**
     * 创建人用户名
     */
    private String creatorName;

    /**
     * 更新人ID
     */
    private String updaterId;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime updateTime;

    /**
     * 签单日
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime signDate;

    /**
     * 开户行ID
     */
    private String bankId;

    /**
     * 开户所需资料
     */
    private String materials;

    /**
     * 是否法定受益人
     */
    private Integer isLegalBeneficiary;

    /**
     * 转介人是否陪同
     */
    private Integer isReferrerAccompany;

    /**
     * 是否有第二持有人
     */
    private Integer isSecond;

    /**
     * 预约-转介人信息日志列表
     */
    private List<ApiAppointmentReferrerLogDto> referrerDtoList;

    /**
     * 预约-签单员信息日志列表
     */
    private List<ApiAppointmentUserSignLogDto> userSignDtoList;
}
