package com.yd.csf.service.vo;

import com.yd.csf.service.model.CustomerExpand;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 客户扩展信息视图
 *
 */
@Data
@Schema(description = "客户扩展信息")
public class CustomerExpandVO implements Serializable {

    /**
     * 客户扩展信息唯一业务ID
     */
    @Schema(description = "客户扩展信息唯一业务ID")
    private String customerExpandBizId;

    /**
     * 客户信息唯一标识(业务ID)
     */
    @Schema(description = "客户信息唯一标识(业务ID)")
    private String customerBizId;

    /**
     * 客户类型
     */
    @Schema(description = "客户类型")
    private Object customerType;

    /**
     * 居住地区代码
     */
    @Schema(description = "居住地区代码")
    private String residenceAreaCode;

    /**
     * 住宅电话
     */
    @Schema(description = "住宅电话")
    private String residenceTelephone;

    /**
     * 是否长期出国
     */
    @Schema(description = "是否长期出国")
    private String longtimeAbroad;

    /**
     * 地址信息
     */
    @Schema(description = "地址信息")
    private List<AddressVO> addressList;

    /**
     * 公司名称
     */
    @Schema(description = "公司名称")
    private String companyName;

    /**
     * 公司地区代码
     */
    @Schema(description = "公司地区代码")
    private String companyAreaCode;

    /**
     * 公司电话
     */
    @Schema(description = "公司电话")
    private String companyTelephone;

    /**
     * 职位
     */
    @Schema(description = "职位")
    private String position;

    /**
     * 工作年限
     */
    @Schema(description = "工作年限")
    private String workYear;

    /**
     * 薪资
     */
    @Schema(description = "薪资")
    private BigDecimal salary;

    /**
     * 通用备注
     */
    private String remark;


    /**
     * 封装类转对象
     *
     * @param customerExpandVO
     * @return
     */
    public static CustomerExpand voToObj(CustomerExpandVO customerExpandVO) {
        if (customerExpandVO == null) {
            return null;
        }
        CustomerExpand customerExpand = new CustomerExpand();
        BeanUtils.copyProperties(customerExpandVO, customerExpand);

        return customerExpand;
    }

    /**
     * 对象转封装类
     *
     * @param customerExpand
     * @return
     */
    public static CustomerExpandVO objToVo(CustomerExpand customerExpand) {
        if (customerExpand == null) {
            return null;
        }
        CustomerExpandVO customerExpandVO = new CustomerExpandVO();
        BeanUtils.copyProperties(customerExpand, customerExpandVO);

        return customerExpandVO;
    }
}
