package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 公式配置表
 * </p>
 *
 * @author zxm
 * @since 2025-10-17
 */
@Getter
@Setter
@TableName("formula_config")
public class FormulaConfig implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 公式配置表唯一业务ID
     */
    @TableField("formula_biz_id")
    private String formulaBizId;

    /**
     * 公式编码
     */
    @TableField("code")
    private String code;

    /**
     * 公式名称
     */
    @TableField("name")
    private String name;

    /**
     * 计算公式（变量中文名称组合，用于展示）
     */
    @TableField("calculation_formula_cn")
    private String calculationFormulaCn;

    /**
     * 计算公式（变量表唯一业务ID组合）
     */
    @TableField("calculation_formula_biz_id")
    private String calculationFormulaBizId;

    /**
     * 描述
     */
    @TableField("description")
    private String description;

    /**
     * 显示顺序
     */
    @TableField("display_order")
    private Integer displayOrder;

    /**
     * 状态(0:停用 1:启用)
     */
    @TableField("status")
    private Integer status;

    /**
     * 所属租户唯一业务ID（冗余）
     */
    @TableField("tenant_biz_id")
    private String tenantBizId;

    /**
     * 所属项目唯一业务ID（冗余）
     */
    @TableField("project_biz_id")
    private String projectBizId;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
