package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 受益人信息表
 * </p>
 *
 * @author zxm
 * @since 2025-09-02
 */
@Getter
@Setter
@TableName("beneficiary")
public class Beneficiary implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 预约信息主表唯一业务ID
     */
    @TableField("appointment_biz_id")
    private String appointmentBizId;

    /**
     * 受益人信息表唯一业务ID
     */
    @TableField("beneficiary_biz_id")
    private String beneficiaryBizId;

    /**
     * 客户类型（字典）(个人或者公司)
     */
    @TableField("customer_type")
    private String customerType;

    /**
     * 与受保人关系（字典）
     */
    @TableField("insurant_rel")
    private String insurantRel;

    /**
     * 受益比例
     */
    @TableField("benefit_ratio")
    private BigDecimal benefitRatio;

    /**
     * 名字
     */
    @TableField("name")
    private String name;

    /**
     * 名字-英文
     */
    @TableField("name_en")
    private String nameEn;

    /**
     * 性别（字典）
     */
    @TableField("gender")
    private String gender;

    /**
     * 证件类型（字典）
     */
    @TableField("document_type")
    private String documentType;

    /**
     * 证件号码
     */
    @TableField("id_number")
    private String idNumber;

    /**
     * 护照号码
     */
    @TableField("passport_number")
    private String passportNumber;

    /**
     * 出生日期
     */
    @TableField("birth_time")
    private LocalDateTime birthTime;

    /**
     * 公司名称
     */
    @TableField("company_name")
    private String companyName;

    /**
     * 公司名称（英文）
     */
    @TableField("company_name_en")
    private String companyNameEn;

    /**
     * 公司商业登记号码
     */
    @TableField("company_business_no")
    private String companyBusinessNo;

    /**
     * 公司注册日期
     */
    @TableField("company_register_time")
    private LocalDateTime companyRegisterTime;

    /**
     * 公司注册地区（字典）
     */
    @TableField("company_register_region")
    private String companyRegisterRegion;

    /**
     * 公司电话区号
     */
    @TableField("company_mobile_code")
    private String companyMobileCode;

    /**
     * 公司电话
     */
    @TableField("company_mobile")
    private String companyMobile;

    /**
     * 公司邮箱
     */
    @TableField("company_email")
    private String companyEmail;

    /**
     * 公司登记地址
     */
    @TableField("company_enter_address")
    private String companyEnterAddress;

    /**
     * 通讯地址
     */
    @TableField("mailing_address")
    private String mailingAddress;

    /**
     * 授权代表姓名中文-名字
     */
    @TableField("auth_name_cn")
    private String authNameCn;

    /**
     * 授权代表姓名英文-名字
     */
    @TableField("auth_name_en")
    private String authNameEn;

    /**
     * 授权代表职称
     */
    @TableField("auth_professional")
    private String authProfessional;

    /**
     * 授权代表电话区号
     */
    @TableField("auth_mobile_code")
    private String authMobileCode;

    /**
     * 授权代表电话
     */
    @TableField("auth_mobile")
    private String authMobile;

    /**
     * 地址列表（json串）
     */
    @TableField("address_list")
    private String addressList;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
