package com.yd.csf.service.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
public class FortuneStatusUpdateRequest {

    @Schema(description = "发佣数据业务Id列表", requiredMode = Schema.RequiredMode.REQUIRED)
    private List<String> fortuneBizIdList;

    /**
     * 发佣状态
     */
    @Schema(description = "发佣状态 '0'-'暂不可发','1'-'可发放','2'-'已发并关账', 字典值: csf_fortune_status")
    private String status;
}
