package com.yd.csf.service.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class FortuneAddRequest implements Serializable {
    /**
     * 出账检核年月 yyyy-MM
     */
    @Schema(description = "出账检核年月 yyyy-MM")
    private String reconciliationYearMonth;

    /**
     * 保单号
     */
    @Schema(description = "保单号", requiredMode = Schema.RequiredMode.REQUIRED)
    private String policyNo;

    /**
     * 发佣期数(1=第一年; 2=第二年; 3=第三年; 4=第四年; 5=第五年)
     */
    @Schema(description = "发佣期数(1=第一年; 2=第二年; 3=第三年; 4=第四年; 5=第五年)", requiredMode = Schema.RequiredMode.REQUIRED)
    private Integer fortunePeriod;

    /**
     * 发佣总期数
     */
    @Schema(description = "发佣总期数", requiredMode = Schema.RequiredMode.REQUIRED)
    private Integer fortuneTotalPeriod;

    /**
     * 转介人
     */
    @Schema(description = "转介人", requiredMode = Schema.RequiredMode.REQUIRED)
    private String broker;

    /**
     * 转介人业务ID
     */
    @Schema(description = "转介人业务ID")
    private String brokerBizId;

    /**
     * 所属团队
     */
    @Schema(description = "所属团队", requiredMode = Schema.RequiredMode.REQUIRED)
    private String team;

    /**
     * 所属团队业务ID
     */
    @Schema(description = "所属团队业务ID")
    private String teamBizId;

    /**
     * 发佣名称
     */
    @Schema(description = "发佣名称", requiredMode = Schema.RequiredMode.REQUIRED)
    private String fortuneName;

    /**
     * 发佣类型
     */
    @Schema(description = "发佣类型")
    private String fortuneType;

    /**
     * 发佣金额
     */
    @Schema(description = "发佣金额", requiredMode = Schema.RequiredMode.REQUIRED)
    private BigDecimal amount;

    /**
     * 发佣币种
     */
    @Schema(description = "发佣币种", requiredMode = Schema.RequiredMode.REQUIRED)
    private String currency;

    /**
     * 发佣日期
     */
    @Schema(description = "发佣日期", requiredMode = Schema.RequiredMode.REQUIRED)
    private Date payoutDate;

    /**
     * 发佣备注
     */
    @Schema(description = "发佣备注")
    private String remark;

    private static final long serialVersionUID = 1L;
}
