package com.yd.csf.api.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.common.enums.ResultCode;
import com.yd.common.result.Result;
import com.yd.csf.service.dto.*;
import com.yd.csf.service.model.CommissionExpected;
import com.yd.csf.service.service.CommissionExpectedService;
import com.yd.csf.service.vo.CommissionExpectedVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

/**
 * CommissionExpected接口
 *
 * @author jianan
 * @since 2025-08-31
 */
@RestController
@RequestMapping("/CommissionExpected")
@Tag(name = "预计来佣接口")
public class ApiCommissionExpectedController {

    @Resource
    private CommissionExpectedService CommissionExpectedService;

    /**
     * 批量新增预计来佣
     *
     * @param commissionExpectedAddRequest
     * @param request
     * @return
     */
    @PostMapping("/add")
    @Operation(summary = "新增预计来佣")
    public Result<Boolean> addCommissionExpected(@RequestBody CommissionExpectedAddRequest commissionExpectedAddRequest, HttpServletRequest request) {
        if (commissionExpectedAddRequest == null) {
            return Result.fail(ResultCode.PARAMS_ERROR.getCode(), ResultCode.PARAMS_ERROR.getMessage());
        }
        return Result.success(CommissionExpectedService.addCommissionExpected(commissionExpectedAddRequest));
    }

    /**
     * 删除预计来佣
     *
     * @param commissionExpectedBizId 预计来佣业务id
     * @param request
     * @return
     */
    @DeleteMapping("/delete")
    @Operation(summary = "删除预计来佣")
    public Result<Boolean> deleteCommissionExpected(@RequestParam("commissionExpectedBizId") String commissionExpectedBizId, HttpServletRequest request) {
        if (StringUtils.isBlank(commissionExpectedBizId)) {
            return Result.fail(ResultCode.PARAMS_ERROR.getCode(), "预计来佣业务id不能为空");
        }
        return Result.success(CommissionExpectedService.deleteCommissionExpected(commissionExpectedBizId));
    }

    /**
     * 更新预计来佣
     *
     * @param commissionExpectedUpdateRequest
     * @return
     */
    @PostMapping("/update")
    @Operation(summary = "更新预计来佣")
    public Result<Boolean> updateCommissionExpected(@RequestBody CommissionExpectedUpdateRequest commissionExpectedUpdateRequest) {
        if (commissionExpectedUpdateRequest == null || StringUtils.isBlank(commissionExpectedUpdateRequest.getCommissionExpectedBizId())) {
            return Result.fail(ResultCode.PARAMS_ERROR.getCode(), "commissionExpectedBizId不能为空");
        }
        return Result.success(CommissionExpectedService.updateCommissionExpected(commissionExpectedUpdateRequest));
    }

    /**
     * 根据 CommissionExpectedBizId 获取CommissionExpected（封装类）
     *
     * @param CommissionExpectedBizId
     * @return
     */
//    @GetMapping("/get/vo")
//    @Operation(summary = "预计来佣详情")
//    public Result<CommissionExpectedVO> getCommissionExpectedVOByBizId(String CommissionExpectedBizId, HttpServletRequest request) {
//        if (StringUtils.isBlank(CommissionExpectedBizId)) {
//            return Result.fail(ResultCode.PARAMS_ERROR.getCode(), "CommissionExpectedBizId不能为空");
//        }
//        // 查询数据库
//        CommissionExpected CommissionExpected = CommissionExpectedService.getByBizId(CommissionExpectedBizId);
//        if (CommissionExpected == null) {
//            return Result.fail(ResultCode.NULL_ERROR.getCode(), ResultCode.NULL_ERROR.getMessage());
//        }
//
//        // 获取封装类
//        return Result.success(CommissionExpectedService.getCommissionExpectedVO(CommissionExpected));
//    }

    /**
     * 分页获取CommissionExpected列表（仅管理员可用）
     *
     * @param CommissionExpectedQueryRequest
     * @return
     */
    @PostMapping("/list/page")
    @Operation(summary = "分页获取预计来佣列表")
    public Result<Page<CommissionExpectedVO>> listCommissionExpectedByPage(@RequestBody CommissionExpectedQueryRequest CommissionExpectedQueryRequest) {
        long current = CommissionExpectedQueryRequest.getPageNo();
        long size = CommissionExpectedQueryRequest.getPageSize();
        // 查询数据库
        Page<CommissionExpected> CommissionExpectedPage = CommissionExpectedService.page(new Page<>(current, size),
                CommissionExpectedService.getQueryWrapper(CommissionExpectedQueryRequest));
        return Result.success(CommissionExpectedService.getCommissionExpectedVOPage(CommissionExpectedPage));
    }

}
