package com.yd.csf.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yd.auth.core.dto.AuthUserDto;
import com.yd.auth.core.utils.SecurityUtil;
import com.yd.common.constant.CommonConstant;
import com.yd.common.enums.CommonEnum;
import com.yd.common.enums.ResultCode;
import com.yd.common.exception.BusinessException;
import com.yd.common.result.Result;
import com.yd.common.utils.RandomStringGenerator;
import com.yd.csf.service.dto.CommissionExpectedAddRequest;
import com.yd.csf.service.dto.CommissionExpectedQueryRequest;
import com.yd.csf.service.enums.CommissionExpectedStatusEnum;
import com.yd.csf.service.enums.CommissionStatusEnum;
import com.yd.csf.service.model.Commission;
import com.yd.csf.service.model.CommissionExpected;
import com.yd.csf.service.model.Policy;
import com.yd.csf.service.service.CommissionExpectedService;
import com.yd.csf.service.dao.CommissionExpectedMapper;
import com.yd.csf.service.vo.CommissionExpectedVO;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
* @author Zhang Jianan
* @description 针对表【commission_expected(预计来佣表)】的数据库操作Service实现
* @createDate 2025-10-08 19:47:40
*/
@Service
public class CommissionExpectedServiceImpl extends ServiceImpl<CommissionExpectedMapper, CommissionExpected>
    implements CommissionExpectedService{

    @Override
    public Page<CommissionExpectedVO> getCommissionExpectedVOPage(Page<CommissionExpected> commissionExpectedPage) {
        List<CommissionExpected> CommissionExpectedList = commissionExpectedPage.getRecords();
        Page<CommissionExpectedVO> CommissionExpectedVOPage = new Page<>(commissionExpectedPage.getCurrent(), commissionExpectedPage.getSize(), commissionExpectedPage.getTotal());
        if (CollUtil.isEmpty(CommissionExpectedList)) {
            return CommissionExpectedVOPage;
        }

        // 填充信息
        List<CommissionExpectedVO> CommissionExpectedVOList = CommissionExpectedList.stream().map(CommissionExpectedVO::objToVo).collect(Collectors.toList());
        CommissionExpectedVOPage.setRecords(CommissionExpectedVOList);
        return CommissionExpectedVOPage;
    }

    /**
     * 校验数据
     *
     * @param commissionExpected
     * @param add      对创建的数据进行校验
     */
    @Override
    public void validCommissionExpected(CommissionExpected commissionExpected, boolean add) {
//        ThrowUtils.throwIf(commissionExpected == null, ErrorCode.PARAMS_ERROR);
//        // todo 从对象中取值
//        String title = commissionExpected.getTitle();
//        // 创建数据时，参数不能为空
//        if (add) {
//            // todo 补充校验规则
//            ThrowUtils.throwIf(StringUtils.isBlank(title), ErrorCode.PARAMS_ERROR);
//        }
//        // 修改数据时，有参数则校验
//        // todo 补充校验规则
//        if (StringUtils.isNotBlank(title)) {
//            ThrowUtils.throwIf(title.length() > 80, ErrorCode.PARAMS_ERROR, "标题过长");
//        }
    }

    /**
     * 获取查询条件
     *
     * @param commissionExpectedQueryRequest
     * @return
     */
    @Override
    public QueryWrapper<CommissionExpected> getQueryWrapper(CommissionExpectedQueryRequest commissionExpectedQueryRequest) {
        QueryWrapper<CommissionExpected> queryWrapper = new QueryWrapper<>();
        if (commissionExpectedQueryRequest == null) {
            return queryWrapper;
        }
        // 获取查询参数
        String policyNo = commissionExpectedQueryRequest.getPolicyNo();
        // 精确查询
        queryWrapper.eq(ObjectUtils.isNotEmpty(policyNo), "policy_no", policyNo);
        // 排序规则
        queryWrapper.orderByAsc("commission_period");
        return queryWrapper;
    }

    /**
     * 获取预计来佣封装
     *
     * @param commissionExpected
     * @return
     */
    @Override
    public CommissionExpectedVO getCommissionExpectedVO(CommissionExpected commissionExpected) {
        // 对象转封装类
        CommissionExpectedVO commissionExpectedVO = CommissionExpectedVO.objToVo(commissionExpected);

        // todo 可以根据需要为封装对象补充值，不需要的内容可以删除

        return commissionExpectedVO;
    }

    @Override
    public Map<String, Object> addCommissionExpected(CommissionExpectedAddRequest commissionExpectedAddRequest) {
        if (commissionExpectedAddRequest == null || StringUtils.isBlank(commissionExpectedAddRequest.getPolicyBizId())) {
            throw new BusinessException(ResultCode.PARAMS_ERROR.getCode(), "policyBizId不能为空");
        }

        CommissionExpected commissionExpected = new CommissionExpected();
        BeanUtils.copyProperties(commissionExpectedAddRequest, commissionExpected);
        // 生成新单编号
        String commissionBizId = RandomStringGenerator.generateBizId16("commission_expected");
        commissionExpected.setCommissionExpectedBizId(commissionBizId);
        // 设置默认状态
        commissionExpected.setStatus(CommissionExpectedStatusEnum.PENDING.getItemValue());
        commissionExpected.setCreateTime(new Date());
        commissionExpected.setUpdateTime(new Date());
        // 新增预计来佣
        this.saveOrUpdate(commissionExpected);
        return Collections.singletonMap("commissionExpectedBizId", commissionExpected.getCommissionExpectedBizId());
    }

    @Override
    public Boolean deleteCommissionExpected(String commissionExpectedBizId) {
        if (StringUtils.isBlank(commissionExpectedBizId)) {
            throw new BusinessException(ResultCode.PARAMS_ERROR.getCode(), "预计来佣业务id不能为空");
        }
        // 校验预计来佣是否存在
        CommissionExpected commissionExpected = this.getOne(new QueryWrapper<CommissionExpected>().eq("commission_expected_biz_id", commissionExpectedBizId));
        if (commissionExpected == null) {
            throw new BusinessException(ResultCode.NULL_ERROR.getCode(), "预计来佣不存在");
        }
        return this.removeById(commissionExpected.getId());
    }
}




