package com.yd.csf.api.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.common.enums.ResultCode;
import com.yd.common.result.Result;
import com.yd.csf.service.dto.*;
import com.yd.csf.service.model.CommissionExpected;
import com.yd.csf.service.service.CommissionExpectedService;
import com.yd.csf.service.vo.CommissionExpectedVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * CommissionExpected接口
 *
 * @author jianan
 * @since 2025-08-31
 */
@RestController
@RequestMapping("/CommissionExpected")
@Tag(name = "预计来佣接口")
public class ApiCommissionExpectedController {

    @Resource
    private CommissionExpectedService CommissionExpectedService;

    /**
     * 新增预计来佣
     *
     * @param CommissionExpectedAddRequest
     * @param request
     * @return
     */
    @PostMapping("/add")
    @Operation(summary = "新增预计来佣")
    public Result<Map<String, Object>> addCommissionExpected(@RequestBody CommissionExpectedAddRequest CommissionExpectedAddRequest, HttpServletRequest request) {
        if (CommissionExpectedAddRequest == null) {
            return Result.fail(ResultCode.PARAMS_ERROR.getCode(), ResultCode.PARAMS_ERROR.getMessage());
        }
        return Result.success(CommissionExpectedService.addCommissionExpected(CommissionExpectedAddRequest));
    }

    /**
     * 删除预计来佣
     *
     * @param commissionExpectedBizId 预计来佣业务id
     * @param request
     * @return
     */
    @DeleteMapping("/delete")
    @Operation(summary = "删除预计来佣")
    public Result<Boolean> deleteCommissionExpected(@RequestParam("commissionExpectedBizId") String commissionExpectedBizId, HttpServletRequest request) {
        if (StringUtils.isBlank(commissionExpectedBizId)) {
            return Result.fail(ResultCode.PARAMS_ERROR.getCode(), "预计来佣业务id不能为空");
        }
        return Result.success(CommissionExpectedService.deleteCommissionExpected(commissionExpectedBizId));
    }

    /**
     * 更新预计来佣
     *
     * @param CommissionExpectedUpdateRequest
     * @return
     */
//    @PostMapping("/update")
//    @Operation(summary = "更新预计来佣")
//    public Result<Boolean> updateCommissionExpected(@RequestBody CommissionExpectedUpdateRequest CommissionExpectedUpdateRequest) {
//        if (CommissionExpectedUpdateRequest == null || StringUtils.isBlank(CommissionExpectedUpdateRequest.getCommissionExpectedBizId())) {
//            throw new BusinessException(ResultCode.PARAMS_ERROR.getCode(), "CommissionExpectedBizId不能为空");
//        }
//        String appointmentNo = null;
//        if (StringUtils.isNotBlank(CommissionExpectedUpdateRequest.getAppointmentBizId())) {
//            Result<ApiAppointmentInfoDto> apiAppointmentInfoDtoResult = appointmentService.mainDetail(CommissionExpectedUpdateRequest.getAppointmentBizId());
//            if (apiAppointmentInfoDtoResult.getData() != null) {
//                ApiAppointmentInfoDto apiAppointmentInfoDto = apiAppointmentInfoDtoResult.getData();
//                appointmentNo = apiAppointmentInfoDto.getAppointmentNo();
//            }
//        }
//
//        return Result.success(CommissionExpectedService.updateCommissionExpected(CommissionExpectedUpdateRequest, appointmentNo));
//    }

    /**
     * 根据 CommissionExpectedBizId 获取CommissionExpected（封装类）
     *
     * @param CommissionExpectedBizId
     * @return
     */
//    @GetMapping("/get/vo")
//    @Operation(summary = "预计来佣详情")
//    public Result<CommissionExpectedVO> getCommissionExpectedVOByBizId(String CommissionExpectedBizId, HttpServletRequest request) {
//        if (StringUtils.isBlank(CommissionExpectedBizId)) {
//            return Result.fail(ResultCode.PARAMS_ERROR.getCode(), "CommissionExpectedBizId不能为空");
//        }
//        // 查询数据库
//        CommissionExpected CommissionExpected = CommissionExpectedService.getByBizId(CommissionExpectedBizId);
//        if (CommissionExpected == null) {
//            return Result.fail(ResultCode.NULL_ERROR.getCode(), ResultCode.NULL_ERROR.getMessage());
//        }
//
//        // 获取封装类
//        return Result.success(CommissionExpectedService.getCommissionExpectedVO(CommissionExpected));
//    }

    /**
     * 分页获取CommissionExpected列表（仅管理员可用）
     *
     * @param CommissionExpectedQueryRequest
     * @return
     */
    @PostMapping("/list/page")
    @Operation(summary = "分页获取预计来佣列表")
    public Result<Page<CommissionExpectedVO>> listCommissionExpectedByPage(@RequestBody CommissionExpectedQueryRequest CommissionExpectedQueryRequest) {
        long current = CommissionExpectedQueryRequest.getPageNo();
        long size = CommissionExpectedQueryRequest.getPageSize();
        // 查询数据库
        Page<CommissionExpected> CommissionExpectedPage = CommissionExpectedService.page(new Page<>(current, size),
                CommissionExpectedService.getQueryWrapper(CommissionExpectedQueryRequest));
        return Result.success(CommissionExpectedService.getCommissionExpectedVOPage(CommissionExpectedPage));
    }

}
