package com.yd.csf.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yd.csf.service.dto.ReconciliationCompanyQueryRequest;
import com.yd.csf.service.model.ReconciliationCompany;
import com.yd.csf.service.dao.ReconciliationCompanyMapper;
import com.yd.csf.service.service.ReconciliationCompanyService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

/**
* @author Zhang Jianan
* @description 针对表【reconciliation_company(对账公司表)】的数据库操作Service实现
* @createDate 2025-10-13 11:17:08
*/
@Service
public class ReconciliationCompanyServiceImpl extends ServiceImpl<ReconciliationCompanyMapper, ReconciliationCompany>
    implements ReconciliationCompanyService {

    @Override
    public Wrapper<ReconciliationCompany> getQueryWrapper(ReconciliationCompanyQueryRequest reconciliationCompanyQueryRequest) {
        QueryWrapper<ReconciliationCompany> queryWrapper = new QueryWrapper<>();
        if (reconciliationCompanyQueryRequest == null) {
            return queryWrapper;
        }

        // 对账公司名称
        String companyName = reconciliationCompanyQueryRequest.getCompanyName();
        queryWrapper.like(StringUtils.isNotBlank(companyName),"company_name", companyName);

        return queryWrapper;
    }
}




