package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * fna表
 * @TableName fna
 */
@TableName(value ="fna")
@Data
public class Fna implements Serializable {
    /**
     * id
     */
    @TableId
    private Long id;

    /**
     * fna唯一业务ID
     */
    private String fnaBizId;

    /**
     * 财富需要分析编号
     */
    private String fnaNo;

    /**
     * 租户编码
     */
    private String tenantCode;

    /**
     * 系统用户唯一业务ID
     */
    private String userBizId;

    /**
     * 客户名称
     */
    private String customerName;

    /**
     * 客户唯一业务ID
     */
    private String customerBizId;

    /**
     * Fna表单唯一业务ID
     */
    private String fnaFormBizId;

    /**
     * 预约编号
     */
    private String appointmentNo;

    /**
     * 预约信息主表唯一业务ID
     */
    private String appointmentBizId;

    /**
     * 预订状态提示
     */
    private String bookingStatusTip;

    /**
     * 核保编号
     */
    private String underwritingNo;

    /**
     * 新单跟进唯一业务ID
     */
    private String policyBizId;

    /**
     * 保单编号
     */
    private String policyNo;

    /**
     * 状态
     */
    private Object status;

    /**
     * 产品代码
     */
    private String productCode;

    /**
     * 产品名称
     */
    private String productName;

    /**
     * 相关URL
     */
    private String url;

    /**
     * 是否可编辑: 0-否, 1-是
     */
    private Integer edit;

    /**
     * 通用备注
     */
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableLogic
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    private String creatorId;

    /**
     * 更新人ID
     */
    private String updaterId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}