package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 业务员累计积分表 - 存储业务员的累计FYC积分和当前等级信息
 * </p>
 *
 * @author zxm
 * @since 2025-10-15
 */
@Getter
@Setter
@TableName("agent_accumulated_fyc")
public class AgentAccumulatedFyc implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 业务员ID（会员唯一业务ID）
     */
    @TableField("agent_id")
    private String agentId;

    /**
     * 累计FYC，业务员历史累计的FYC总额
     */
    @TableField("total_fyc")
    private BigDecimal totalFyc;

    /**
     * 当前等级，业务员当前的会员等级编码（会员等级配置表等级编码）
     */
    @TableField("current_grade_code")
    private String currentGradeCode;

    /**
     * 最后计算日期，记录最后一次计算累计FYC的日期
     */
    @TableField("last_calc_date")
    private LocalDateTime lastCalcDate;

    /**
     * 状态(0:停用 1:启用)
     */
    @TableField("status")
    private Integer status;

    /**
     * 所属租户唯一业务ID（冗余）
     */
    @TableField("tenant_biz_id")
    private String tenantBizId;

    /**
     * 所属项目唯一业务ID（冗余）
     */
    @TableField("project_biz_id")
    private String projectBizId;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
