package com.yd.csf.feign.dto.excel;

import com.yd.common.enums.DictTypeEnum;
import com.yd.common.utils.DateUtil;
import com.yd.user.feign.response.sysdict.GetDictItemListByDictTypeResponse;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 受保人资料 (如與保單持有人為同一人無須填寫)
 */
@Data
public class ApiExcelInsurantDto {

    //============以下是表字段============
    /**
     * 與投保人關系（受保人信息表：与投保人关系（字典））
     */
    private String policyholderRel;

    /**
     * 中文姓名（受保人信息表：名字）
     */
    private String name;

    /**
     * 英文姓名 (同护照)（受保人信息表：名字-英文）
     */
    private String nameEn;

    /**
     * 性别（受保人信息表：性别）
     */
    private String gender;

    /**
     * 婚姻状况 (單身 / 已婚 / 離異/ 喪偶)（受保人信息表：婚姻状况（字典））
     */
    private String maritalStatus;

    /**
     * 出生日期 (西元 年/月/日)（受保人信息表：出生日期）
     */
    private LocalDateTime birthday;

    /**
     * 出生地 (省/市)（受保人信息表：出生地（省市））
     */
    private String birthplace;

    /**
     * 國籍（受保人信息表：国籍）
     */
    private String nationality;

    /**
     * 身份证号码（受保人信息表：证件号码）
     */
    private String idNumber;

    /**
     * 護照號碼（受保人信息表：护照号码）
     */
    private String passportNo;

    /**
     * 港澳通行证号码（受保人信息表：通行证号码）
     */
    private String passNo;

    /**
     * 永久(住宅)地址（受保人信息表：居住地址）
     */
    private String residentialAddress;

    /**
     * 通訊地址（受保人信息表：通讯地址）
     */
    private String mailingAddress;

    /**
     * 聯絡電話(手機)区号（受保人信息表：移动电话区号）
     */
    private String mobileCode;

    /**
     * 聯絡電話(手機)（受保人信息表：移动电话） 区号+号码
     */
    private String mobile;

    /**
     * 聯絡電話(住宅) 区号+号码 TODO
     */
    private String residenceMobile;

    /**
     * 电邮地址（受保人信息表：邮箱）
     */
    private String email;

    /**
     * 教育程度 (大學或以上/大專/中學/小學或以下)（受保人信息表：教育程度（字典））
     */
    private String educationLevel;

    /**
     * 公司名称（受保人信息表：公司名称）
     */
    private String companyName;

    /**
     * 工作年期(僅限數字)（受保人信息表：总工作年期）
     */
    private BigDecimal totalWorkingYears;

    /**
     * 职位及日常职务（受保人信息表：职位）
     */
    private String position;

    /**
     * 公司业务性质（受保人信息表：TODO）
     */
    private String companyNature;

    /**
     * 公司地址（受保人信息表：公司地址）
     */
    private String companyAddress;

    /**
     * 现时每月收入 (HKD)（受保人信息表：现时每月收入）
     */
    private BigDecimal currentMonthlyIncome;


    //============以下是excel显示的字段，同上============

    /**
     * 與投保人關系（受保人信息表：与投保人关系（字典））
     */
    private String insurantPolicyholderRel;

    /**
     * 中文姓名（受保人信息表：名字）
     */
    private String insurantName;

    /**
     * 英文姓名 (同护照)（受保人信息表：名字-英文）
     */
    private String insurantNameEn;

    /**
     * 性别（受保人信息表：性别）
     */
    private String insurantGender;

    /**
     * 婚姻状况 (單身 / 已婚 / 離異/ 喪偶)（受保人信息表：婚姻状况（字典））
     */
    private String insurantMaritalStatus;

    /**
     * 出生日期 (西元 年/月/日)（受保人信息表：出生日期）
     */
    private String insurantBirthday;

    /**
     * 出生地 (省/市)（受保人信息表：出生地（省市））
     */
    private String insurantBirthplace;

    /**
     * 國籍（受保人信息表：国籍）
     */
    private String insurantNationality;

    /**
     * 身份证号码（受保人信息表：证件号码）
     */
    private String insurantIdNumber;

    /**
     * 護照號碼（受保人信息表：护照号码）
     */
    private String insurantPassportNo;

    /**
     * 港澳通行证号码（受保人信息表：通行证号码）
     */
    private String insurantPassNo;

    /**
     * 永久(住宅)地址（受保人信息表：居住地址）
     */
    private String insurantResidentialAddress;

    /**
     * 通訊地址（受保人信息表：通讯地址）
     */
    private String insurantMailingAddress;

    /**
     * 聯絡電話(手機)（受保人信息表：移动电话） 区号+号码
     */
    private String insurantMobile;

    /**
     * 聯絡電話(住宅) 区号+号码 TODO
     */
    private String insurantResidenceMobile;

    /**
     * 电邮地址（受保人信息表：邮箱）
     */
    private String insurantEmail;

    /**
     * 教育程度 (大學或以上/大專/中學/小學或以下)（受保人信息表：教育程度（字典））
     */
    private String insurantEducationLevel;

    /**
     * 公司名称（受保人信息表：公司名称）
     */
    private String insurantCompanyName;

    /**
     * 工作年期(僅限數字)（受保人信息表：总工作年期）
     */
    private BigDecimal insurantTotalWorkingYears;

    /**
     * 职位及日常职务（受保人信息表：职位）
     */
    private String insurantPosition;

    /**
     * 公司业务性质（受保人信息表：TODO）
     */
    private String insurantPompanyNature;

    /**
     * 公司地址（受保人信息表：公司地址）
     */
    private String insurantCompanyAddress;

    /**
     * 现时每月收入 (HKD)（受保人信息表：现时每月收入）
     */
    private BigDecimal insurantCurrentMonthlyIncome;

    /**
     * 重新赋值ApiExcelHkStayDto
     * @param dto
     * @return
     */
    public static ApiExcelInsurantDto setApiExcelInsurantDto(ApiExcelInsurantDto dto,
                                                             List<GetDictItemListByDictTypeResponse> dictTypeResponses) {
        ApiExcelInsurantDto insurantDto = new ApiExcelInsurantDto();
        BeanUtils.copyProperties(dto,insurantDto);
        insurantDto.setInsurantBirthday(DateUtil.getyyyyMMdd(dto.getBirthday()));
        //出生地 (省/市)（受保人信息表：出生地（省市））TODO
        insurantDto.setInsurantBirthplace(dto.getBirthplace());
        insurantDto.setInsurantCompanyAddress(dto.getCompanyAddress());
        insurantDto.setInsurantCompanyName(dto.getCompanyName());
        insurantDto.setInsurantCurrentMonthlyIncome(dto.getCurrentMonthlyIncome());
        //教育程度 (大學或以上/大專/中學/小學或以下)（受保人信息表：教育程度（字典））
        insurantDto.setInsurantEducationLevel(GetDictItemListByDictTypeResponse.getItemLabel(dictTypeResponses,
                DictTypeEnum.CSF_EDUCATION.getItemValue(),dto.getEducationLevel()));
        insurantDto.setInsurantEmail(dto.getEmail());
        //性别（受保人信息表：性别  字典）
        insurantDto.setInsurantGender(dto.getGender());
        insurantDto.setInsurantIdNumber(dto.getIdNumber());
        insurantDto.setInsurantMailingAddress(dto.getMailingAddress());
        //婚姻状况 (單身 / 已婚 / 離異/ 喪偶)（受保人信息表：婚姻状况（字典））
        insurantDto.setInsurantMaritalStatus(GetDictItemListByDictTypeResponse.getItemLabel(dictTypeResponses,
                DictTypeEnum.CSF_MARRIAGE.getItemValue(),dto.getMaritalStatus()));
        insurantDto.setInsurantMobile(dto.getMobileCode() + "-" + dto.getMobile());
        insurantDto.setInsurantName(dto.getName());
        insurantDto.setInsurantNameEn(dto.getNameEn());
        //國籍（受保人信息表：国籍）字典 TODO
        insurantDto.setInsurantNationality(dto.getNationality());
        insurantDto.setInsurantPassNo(dto.getPassNo());
        insurantDto.setInsurantPassportNo(dto.getPassportNo());
        //與投保人關系（受保人信息表：与投保人关系（字典））
        insurantDto.setInsurantPolicyholderRel(GetDictItemListByDictTypeResponse.getItemLabel(dictTypeResponses,
                DictTypeEnum.CSF_AP_REL.getItemValue(),dto.getPolicyholderRel()));
        //公司业务性质（受保人信息表：TODO）
        insurantDto.setInsurantPompanyNature(dto.getInsurantPompanyNature());
        insurantDto.setInsurantPosition(dto.getPosition());
        //聯絡電話(住宅) 区号+号码 TODO
        insurantDto.setInsurantResidenceMobile(dto.getResidenceMobile());
        insurantDto.setInsurantResidentialAddress(dto.getResidentialAddress());
        insurantDto.setInsurantTotalWorkingYears(dto.getTotalWorkingYears());
        return insurantDto;
    }
}
