package com.yd.csf.feign.dto.excel;

import com.yd.oss.feign.annotation.ExcelField;
import lombok.Data;

import java.math.BigDecimal;

/**
 * Excel导入-受益人列表信息
 */
@Data
public class ApiExcelImportBeneficiaryDto {

    /**
     * 中文姓名（受益人信息表：名字）
     * 相对行号：每个受益人组内的第0行
     */
    @ExcelField(name = "中文姓名", titleRow = 0, titleCol = 0, valueRow = 0, valueCol = 1)
    private String beneficiaryName;

    /**
     * 英文姓名 (同护照)（受益人信息表：名字-英文）
     * 相对行号：每个受益人组内的第0行
     */
    @ExcelField(name = "英文姓名", titleRow = 0, titleCol = 2, valueRow = 0, valueCol = 3)
    private String beneficiaryNameEn;

    /**
     * 出生日期 (西元 年/月/日)（受益人信息表：出生日期）
     * 相对行号：每个受益人组内的第1行
     */
    @ExcelField(name = "出生日期", titleRow = 1, titleCol = 0, valueRow = 1, valueCol = 1)
    private String beneficiaryBirthTime;

    /**
     * 身份证号码（受益人信息表：证件号码）
     * 相对行号：每个受益人组内的第1行
     */
    @ExcelField(name = "身份证号码", titleRow = 1, titleCol = 2, valueRow = 1, valueCol = 3)
    private String beneficiaryIdNumber;

    /**
     * 與受保人關係（受益人信息表：与受保人关系（字典））
     * 相对行号：每个受益人组内的第2行
     */
    @ExcelField(name = "與受保人關係", titleRow = 2, titleCol = 0, valueRow = 2, valueCol = 1)
    private String beneficiaryInsurantRel;

    /**
     * 受益比例 (%)（受益人信息表：受益比例）
     * 相对行号：每个受益人组内的第2行
     */
    @ExcelField(name = "受益比例 (%)", titleRow = 2, titleCol = 2, valueRow = 2, valueCol = 3)
    private BigDecimal beneficiaryBenefitRatio;
}