package com.yd.csf.feign.dto.appointment;

import lombok.Data;
import java.math.BigDecimal;

@Data
public class ApiAppointmentBriefInfoDto {

    /**
     * 预约信息主表主键id
     */
    private Long id;

    /**
     * 预约信息主表唯一业务ID
     */
    private String appointmentBizId;

    /**
     * 预约编号
     */
    private String appointmentNo;

    /**
     * 关联客户信息表唯一业务ID（冗余字段）
     */
    private String customerBizId;

    /**
     * 关联客户编号（和客户信息表唯一业务ID是一对，唯一，冗余字段）
     */
    private String customerNo;

    /**
     * 客户姓名
     */
    private String customerName;

    /**
     * 保险产品名称（中台保险产品名称，冗余）
     */
    private String productName;

    /**
     * 供款年期（字典）
     */
    private String paymentTerm;

    /**
     * 每期保费
     */
    private BigDecimal eachIssuePremium;
}
