package com.yd.csf.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.csf.api.service.ApiVariableService;
import com.yd.csf.feign.client.variable.ApiVariableFeignClient;
import com.yd.csf.feign.request.variable.ApiVariableAddRequest;
import com.yd.csf.feign.request.variable.ApiVariableEditRequest;
import com.yd.csf.feign.request.variable.ApiVariablePageRequest;
import com.yd.csf.feign.response.variable.ApiVariableDetailResponse;
import com.yd.csf.feign.response.variable.ApiVariablePageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 变量信息
 *
 * @author zxm
 * @since 2025-10-16
 */
@RestController
@RequestMapping("/variable")
@Validated
public class ApiVariableController implements ApiVariableFeignClient {

    @Autowired
    private ApiVariableService apiVariableService;

    /**
     * 分页查询-变量信息
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiVariablePageResponse>> page(ApiVariablePageRequest request) {
        return apiVariableService.page(request);
    }

    /**
     * 详情-变量信息
     * @param variableBizId
     * @return
     */
    @Override
    public Result<ApiVariableDetailResponse> detail( String variableBizId) {
        return apiVariableService.detail(variableBizId);
    }

    /**
     * 添加-变量信息
     * @param request
     * @return
     */
    @Override
    public Result add(ApiVariableAddRequest request) {
        return apiVariableService.add(request);
    }

    /**
     * 编辑-变量信息
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiVariableEditRequest request) {
        return apiVariableService.edit(request);
    }

    /**
     * 删除-变量信息 TODO
     * @param variableBizId
     * @return
     */
    @Override
    public Result del(String variableBizId) {
        return apiVariableService.detail(variableBizId);
    }
}
