package com.yd.csf.service.vo;

import cn.hutool.json.JSONUtil;

import com.yd.csf.service.model.FnaForm;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * Fna表单视图
 *
 */
@Data
public class FnaFormVO implements Serializable {

    /**
     * id
     */
    private Long id;

    /**
     * 标题
     */
    private String title;

    /**
     * 内容
     */
    private String content;

    /**
     * 创建用户 id
     */
    private Long userId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 标签列表
     */
    private List<String> tagList;


    /**
     * 封装类转对象
     *
     * @param fnaFormVO
     * @return
     */
    public static FnaForm voToObj(FnaFormVO fnaFormVO) {
        if (fnaFormVO == null) {
            return null;
        }
        FnaForm fnaForm = new FnaForm();
        BeanUtils.copyProperties(fnaFormVO, fnaForm);
        List<String> tagList = fnaFormVO.getTagList();

        return fnaForm;
    }

    /**
     * 对象转封装类
     *
     * @param fnaForm
     * @return
     */
    public static FnaFormVO objToVo(FnaForm fnaForm) {
        if (fnaForm == null) {
            return null;
        }
        FnaFormVO fnaFormVO = new FnaFormVO();
        BeanUtils.copyProperties(fnaForm, fnaFormVO);

        return fnaFormVO;
    }
}
