package com.yd.csf.service.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 创建Fna表单请求
 *
 */
@Data
public class FnaFormAddRequest implements Serializable {

    /**
     * 保存方式 temp-暂存 save-保存
     */
    @Schema(description = "保存方式 temp-暂存 save-保存", requiredMode = Schema.RequiredMode.REQUIRED)
    private String saveType;

    /**
     * 客户唯一业务ID
     */
    @Schema(description = "客户唯一业务ID")
    private String customerBizId;

    /**
     * 个人资料
     */
    @Schema(description = "个人资料")
    private PersonalData personalData;

    /**
     * 家庭状况
     */
    @Schema(description = "家庭状况（父亲-father/母亲-mother/配偶-spouse/子女-children）")
    private List<FamilyMember> familyMembers;

    /**
     * 保单持有人个人已有保障
     */
    private List<ExistingSecurity> existingSecurityOwner;

    /**
     * 受保人个人已有保障
     */
    private List<ExistingSecurity> existingSecurityInsured;

    /**
     * 平均月收入
     */
    @Schema(description = "在过去24个月里，你从所有所得的收入来源所得的平均每月收入为?(包括薪金、花红、佣金、其他薪酬红利、银行存款利息、债券利息及股息等")
    private String monthlyIncome;

    /**
     * 平均月支出
     */
    @Schema(description = "过去24个月每月里，你每月的平均开支为?")
    private String monthlyExpense;

    /**
     * 累积流动资产
     */
    @Schema(description = "您现时的累积流动资产约有多少?")
    private String liquidAssets;

    /**
     * 流动资产种类
     */
    @Schema(description = "流动资产种类，多选逗号隔开 字典值：csf_liquid_asset_type")
    private String liquidAssetType;

    /**
     * 其他流动资产的说明
     */
    @Schema(description = "其他流动资产的说明")
    private String otherLiquidAsset;

    /**
     * 保单持有人资产
     */
    @Schema(description = "保单持有人资产")
    private OwnerAssets ownerAssets;

    /**
     * 公司业务资料
     */
    @Schema(description = "公司业务资料")
    private CompanyBusinessData companyBusinessData;

    @Schema(description = "首期及续保保费的财富来源，单选 字典值：csf_premium_funding_source")
    private String premiumFundingSource;

    private static final long serialVersionUID = 1L;
}