package com.yd.csf.api.controller;

import com.alibaba.excel.EasyExcel;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.common.result.Result;
import com.yd.common.utils.RandomStringGenerator;
import com.yd.csf.api.dto.PolicyExcelDTO;
import com.yd.csf.api.listener.PolicyDataListener;
import com.yd.csf.service.common.ErrorCode;
import com.yd.csf.service.dto.PolicyFollowQueryRequest;
import com.yd.csf.service.model.Customer;
import com.yd.csf.service.model.PolicyFollow;
import com.yd.csf.service.service.CustomerExpandService;
import com.yd.csf.service.service.PolicyFollowService;
import com.yd.user.feign.client.sysuser.ApiSysUserFeignClient;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * customer接口
 *
 * @author jianan
 * @since 2025-07-31
 */
@RestController
@RequestMapping("/policy_follow")
@Tag(name = "新单跟进接口")
public class ApiPolicyFollowController {

    private static final Logger log = LoggerFactory.getLogger(ApiPolicyFollowController.class);

    @Resource
    private PolicyFollowService policyFollowService;

    @Resource
    private PolicyDataListener policyDataListener;


    @PostMapping("/upload/excel")
    public Result<Boolean> uploadExcel(@RequestParam("file") MultipartFile file) throws IOException {
        EasyExcel.read(file.getInputStream(), PolicyExcelDTO.class, policyDataListener).sheet("保单").doRead();

        List<PolicyExcelDTO> dtoList = policyDataListener.getList();
        log.info("导入成功，共 " + dtoList.size() + " 条数据");

        List<PolicyFollow> list =  convertToObj(dtoList);

        for (PolicyFollow policyFollow : list) {
            log.info("policyFollow = " + policyFollow);
        }

        return Result.success(policyFollowService.uploadExcel(list));
    }

    private List<PolicyFollow> convertToObj(List<PolicyExcelDTO> list) {
        List<PolicyFollow> policyFollows = new ArrayList<>();
        for (PolicyExcelDTO policyExcelDTO : list) {
            PolicyFollow policyFollow = new PolicyFollow();
            BeanUtils.copyProperties(policyExcelDTO, policyFollow);
            policyFollow.setPolicyBizId(RandomStringGenerator.generateBizId16("policy"));
        }
        return policyFollows;
    }

    /**
     * 创建新单跟进
     *
     * @param customerAddRequest
     * @param request
     * @return
     */
//    @Operation(summary = "创建新单跟进")
//    @PostMapping("/add")
//    @Transactional(rollbackFor = Exception.class)
//    public Result<Map<String, Object>> addCustomer(@RequestBody CustomerAddRequest customerAddRequest, HttpServletRequest request) {
//        if (customerAddRequest == null) {
//            return Result.fail(ErrorCode.PARAMS_ERROR.getCode(), ErrorCode.PARAMS_ERROR.getMessage());
//        }
//        return Result.success(policyFollowService.addCustomer(customerAddRequest));
//    }

    /**
     * 删除fna
     *
     * @param deleteRequest
     * @param request
     * @return
     */
//    @PostMapping("/delete")
//    public Result<Boolean> deleteFna(@RequestBody DeleteRequest deleteRequest, HttpServletRequest request) {
//        if (deleteRequest == null || deleteRequest.getId() <= 0) {
//            throw new BusinessException(ErrorCode.PARAMS_ERROR);
//        }
//        User user = userService.getLoginUser(request);
//        long id = deleteRequest.getId();
//        // 判断是否存在
//        Customer oldFna = policyFollowService.getById(id);
//        ThrowUtils.throwIf(oldFna == null, ErrorCode.NOT_FOUND_ERROR);
//        // 仅本人或管理员可删除
//        if (!oldFna.getUserId().equals(user.getId()) && !userService.isAdmin(request)) {
//            throw new BusinessException(ErrorCode.NO_AUTH_ERROR);
//        }
//        // 操作数据库
//        boolean result = policyFollowService.removeById(id);
//        ThrowUtils.throwIf(!result, ErrorCode.OPERATION_ERROR);
//        return Result.success(true);
//    }

    /**
     * 更新新单跟进
     *
     * @param customerUpdateRequest
     * @return
     */
//    @PostMapping("/update")
//    @Operation(summary = "更新新单跟进信息")
//    public Result<Boolean> updateCustomer(@RequestBody CustomerUpdateRequest customerUpdateRequest) {
//        if (customerUpdateRequest == null || customerUpdateRequest.getCustomerBizId() == null) {
//            throw new BusinessException(ErrorCode.PARAMS_ERROR.getCode(), ErrorCode.PARAMS_ERROR.getMessage());
//        }
//        return Result.success(policyFollowService.updateCustomer(customerUpdateRequest));
//    }

    /**
     * 根据 customerBizId 获取新单跟进（封装类）
     *
     * @param policyBizId
     * @return
     */
    @GetMapping("/get/vo")
    @Operation(summary = "根据 policyBizId 获取新单跟进详情")
    public Result<PolicyFollow> getPolicyFollowByPolicyBizId(@RequestParam("policyBizId") String policyBizId, HttpServletRequest request) {
        if (policyBizId == null) {
            return Result.fail(ErrorCode.PARAMS_ERROR.getCode(), ErrorCode.PARAMS_ERROR.getMessage());
        }
        // 查询数据库
        PolicyFollow policyFollow = policyFollowService.getByPolicyBizId(policyBizId);
        if (policyFollow == null) {
            return Result.fail(ErrorCode.NOT_FOUND_ERROR.getCode(), ErrorCode.NOT_FOUND_ERROR.getMessage());
        }

        // 获取封装类
        return Result.success(policyFollow);
    }

    /**
     * 分页获取新单跟进列表（仅管理员可用）
     *
     * @param fnaQueryRequest
     * @return
     */
//    @PostMapping("/list/page")
//    public Result<Page<Customer>> listFnaByPage(@RequestBody FnaQueryRequest fnaQueryRequest) {
//        long current = fnaQueryRequest.getPageNo();
//        long size = fnaQueryRequest.getPageSize();
//        // 查询数据库
//        Page<Customer> fnaPage = policyFollowService.page(new Page<>(current, size),
//                policyFollowService.getQueryWrapper(fnaQueryRequest));
//        return Result.success(fnaPage);
//    }

    /**
     * 分页获取新单跟进列表（VO）
     *
     * @param policyFollowQueryRequest
     * @param request
     * @return
     */
    @PostMapping("/list/page/vo")
    @Operation(summary = "分页获取新单跟进列表")
    public Result<Page<PolicyFollow>> listPolicyFollowByPage(@RequestBody PolicyFollowQueryRequest policyFollowQueryRequest,
                                                         HttpServletRequest request) {
        long current = policyFollowQueryRequest.getPageNo();
        long size = policyFollowQueryRequest.getPageSize();

        // 查询数据库
        Page<PolicyFollow> policyFollowPage = policyFollowService.page(new Page<>(current, size),
                policyFollowService.getQueryWrapper(policyFollowQueryRequest));
        // 获取封装类
//        return Result.success(policyFollowService.getPolicyFollowVOPage(policyFollowPage));
        return Result.success(policyFollowPage);
    }

}
