package com.yd.csf.feign.response.expectedfortune;

import lombok.Data;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class ApiExpectedFortunePageResponse {

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 预计发佣表唯一业务id
     */
    private String expectedFortuneBizId;

    /**
     * 保单号
     */
    private String policyNo;

    /**
     * 发佣期数(1=第一年; 2=第二年; 3=第三年; 4=第四年; 5=第五年)
     */
    private Integer fortunePeriod;

    /**
     * 发佣总期数
     */
    private Integer fortuneTotalPeriod;

    /**
     * 转介人名称
     */
    private String broker;

    /**
     * 转介人业务ID
     */
    private String brokerBizId;

    /**
     * 团队名称
     */
    private String team;

    /**
     * 所属团队业务ID
     */
    private String teamBizId;

    /**
     * 发佣名称
     */
    private String fortuneName;

    /**
     * 发佣类型
     */
    private String fortuneType;

    /**
     * 发佣金额
     */
    private BigDecimal amount;

    /**
     * 发佣币种
     */
    private String currency;

    /**
     * 基本法项目配置表唯一业务ID
     */
    private String ruleItemBizId;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

}
